/*
 * Decompiled with CFR 0.152.
 */
package net.atomique.ksar;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.JFileChooser;
import net.atomique.ksar.Config;
import net.atomique.ksar.GlobalOptions;
import net.atomique.ksar.kSar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileRead
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(FileRead.class);
    private kSar mysar = null;
    private String sarfilename = null;
    private FileReader tmpfile = null;
    private BufferedReader myfilereader = null;

    public FileRead(kSar hissar) {
        int returnVal;
        this.mysar = hissar;
        JFileChooser fc = new JFileChooser();
        if (Config.getLastReadDirectory() != null) {
            fc.setCurrentDirectory(Config.getLastReadDirectory());
        }
        if ((returnVal = fc.showDialog(GlobalOptions.getUI(), "Open")) == 0) {
            this.sarfilename = fc.getSelectedFile().getAbsolutePath();
            if (fc.getSelectedFile().isDirectory()) {
                Config.setLastReadDirectory(fc.getSelectedFile());
            } else {
                Config.setLastReadDirectory(fc.getSelectedFile().getParentFile());
            }
            Config.save();
        }
    }

    public FileRead(kSar hissar, String filename) {
        this.mysar = hissar;
        this.sarfilename = filename;
    }

    public String get_action() {
        if (this.sarfilename != null) {
            return "file://" + this.sarfilename;
        }
        return null;
    }

    private void close() {
        try {
            if (this.myfilereader != null) {
                this.myfilereader.close();
            }
            if (this.tmpfile != null) {
                this.tmpfile.close();
            }
        }
        catch (IOException ex) {
            log.error("IO Exception", ex);
        }
    }

    @Override
    public void run() {
        if (this.sarfilename == null) {
            return;
        }
        try {
            this.tmpfile = new FileReader(this.sarfilename);
        }
        catch (FileNotFoundException ex) {
            log.error("IO Exception", ex);
        }
        this.myfilereader = new BufferedReader(this.tmpfile);
        this.mysar.parse(this.myfilereader);
        this.close();
    }
}

