/*
 * Decompiled with CFR 0.152.
 */
package net.atomique.ksar;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import net.atomique.ksar.GlobalOptions;
import net.atomique.ksar.kSar;
import net.atomique.ksar.xml.CnxHistory;
import org.slf4j.LoggerFactory;

public class SSHCommand
extends Thread {
    private static final org.slf4j.Logger log = LoggerFactory.getLogger(SSHCommand.class);
    private JButton Cancelbutton;
    private JLabel ComboBoxLabel;
    private JButton ConnectionButton;
    private JComboBox HostComboBox;
    private JLabel HostnameLabel;
    private JPasswordField PasswordField;
    private JLabel PasswordLabel;
    private JPanel buttonpanel;
    private JComboBox commandComboBox;
    private JPanel commandPanel;
    private JPanel headerpanel;
    private JPanel hostnamePanel;
    private JPanel infopanel;
    private JPanel passwordPanel;
    private JLabel titleLabel;
    private DefaultComboBoxModel userhostModel = new DefaultComboBoxModel();
    private DefaultComboBoxModel commandModel = new DefaultComboBoxModel();
    private String command;
    private kSar mysar;
    private JDialog dialog = new JDialog();
    private JSch jsch = null;
    private Session session = null;
    private Channel channel = null;
    private int num_try = 0;
    private InputStream in = null;
    private InputStream err = null;
    String password = null;

    public SSHCommand(kSar hissar, String cmd) {
        this.mysar = hissar;
        this.command = cmd;
    }

    public SSHCommand(kSar hissar) {
        this.mysar = hissar;
        this.showDialog();
    }

    public String get_action() {
        if (this.command != null) {
            return "ssh://" + this.command;
        }
        return null;
    }

    private void showDialog() {
        Iterator<String> ite = GlobalOptions.getHistoryList().keySet().iterator();
        while (ite.hasNext()) {
            CnxHistory tmp = GlobalOptions.getHistory(ite.next());
            this.userhostModel.addElement(tmp.getLink());
        }
        this.initComponents(this.dialog);
        if (this.HostComboBox.getItemCount() > 0) {
            this.HostComboBox.setSelectedIndex(0);
        }
        this.dialog.setLocationRelativeTo(GlobalOptions.getUI());
        this.dialog.setVisible(true);
    }

    private void initComponents(JDialog dialog) {
        this.headerpanel = new JPanel();
        this.titleLabel = new JLabel();
        this.infopanel = new JPanel();
        this.hostnamePanel = new JPanel();
        this.HostnameLabel = new JLabel();
        this.HostComboBox = new JComboBox();
        this.passwordPanel = new JPanel();
        this.PasswordLabel = new JLabel();
        this.PasswordField = new JPasswordField();
        this.commandPanel = new JPanel();
        this.ComboBoxLabel = new JLabel();
        this.commandComboBox = new JComboBox();
        this.buttonpanel = new JPanel();
        this.Cancelbutton = new JButton();
        this.ConnectionButton = new JButton();
        dialog.setDefaultCloseOperation(0);
        dialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.titleLabel.setFont(new Font("Tahoma", 1, 14));
        this.titleLabel.setText("SSH Connection");
        this.headerpanel.add(this.titleLabel);
        dialog.getContentPane().add((Component)this.headerpanel, "First");
        this.infopanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.infopanel.setLayout(new BoxLayout(this.infopanel, 3));
        this.hostnamePanel.setLayout(new FlowLayout(0));
        this.HostnameLabel.setLabelFor(this.HostComboBox);
        this.HostnameLabel.setText("User@Host");
        this.hostnamePanel.add(this.HostnameLabel);
        this.HostComboBox.setEditable(true);
        this.HostComboBox.setModel(this.userhostModel);
        this.HostComboBox.setMinimumSize(new Dimension(159, 27));
        this.HostComboBox.setPreferredSize(new Dimension(159, 27));
        this.HostComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SSHCommand.this.HostComboBoxActionPerformed(evt);
            }
        });
        this.hostnamePanel.add(this.HostComboBox);
        this.infopanel.add(this.hostnamePanel);
        this.passwordPanel.setLayout(new FlowLayout(0));
        this.PasswordLabel.setLabelFor(this.PasswordField);
        this.PasswordLabel.setText("Password");
        this.PasswordLabel.setPreferredSize(new Dimension(69, 16));
        this.passwordPanel.add(this.PasswordLabel);
        this.PasswordField.setMinimumSize(new Dimension(100, 20));
        this.PasswordField.setPreferredSize(new Dimension(120, 20));
        this.passwordPanel.add(this.PasswordField);
        this.infopanel.add(this.passwordPanel);
        this.commandPanel.setLayout(new FlowLayout(0));
        this.ComboBoxLabel.setLabelFor(this.commandComboBox);
        this.ComboBoxLabel.setText("Command");
        this.ComboBoxLabel.setPreferredSize(new Dimension(69, 16));
        this.commandPanel.add(this.ComboBoxLabel);
        this.commandComboBox.setEditable(true);
        this.commandComboBox.setModel(this.commandModel);
        this.commandComboBox.setPreferredSize(new Dimension(150, 20));
        this.commandPanel.add(this.commandComboBox);
        this.infopanel.add(this.commandPanel);
        dialog.getContentPane().add((Component)this.infopanel, "Center");
        this.Cancelbutton.setText("Cancel");
        this.Cancelbutton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SSHCommand.this.CancelbuttonActionPerformed(evt);
            }
        });
        this.buttonpanel.add(this.Cancelbutton);
        this.ConnectionButton.setText("Connection");
        this.ConnectionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SSHCommand.this.ConnectionButtonActionPerformed(evt);
            }
        });
        this.buttonpanel.add(this.ConnectionButton);
        dialog.getContentPane().add((Component)this.buttonpanel, "South");
        dialog.pack();
    }

    private void CancelbuttonActionPerformed(ActionEvent evt) {
        this.dialog.dispose();
    }

    private void ConnectionButtonActionPerformed(ActionEvent evt) {
        this.dialog.dispose();
        this.connect();
    }

    private void HostComboBoxActionPerformed(ActionEvent evt) {
        JComboBox cb = (JComboBox)evt.getSource();
        String link = (String)cb.getSelectedItem();
        CnxHistory tmp = GlobalOptions.getHistory(link);
        this.commandModel.removeAllElements();
        if (tmp != null) {
            Iterator<String> ite = tmp.getCommandList().iterator();
            while (ite.hasNext()) {
                this.commandModel.addElement(ite.next());
            }
        } else {
            this.commandModel.addElement("sar -A");
        }
    }

    private void connect() {
        CnxHistory tmp = new CnxHistory((String)this.HostComboBox.getSelectedItem());
        tmp.addCommand((String)this.commandComboBox.getSelectedItem());
        this.jsch = new JSch();
        try {
            this.session = this.jsch.getSession(tmp.getUsername(), tmp.getHostname(), tmp.getPortInt());
        }
        catch (JSchException ex) {
            log.error("JSchException ", ex);
        }
        Properties config = new Properties();
        config.put("StrictHostKeyChecking", "no");
        this.session.setConfig(config);
        char[] response = new char[this.PasswordField.getPassword().length];
        StringBuilder t = new StringBuilder();
        for (int i = 0; i < this.PasswordField.getPassword().length; ++i) {
            response[i] = this.PasswordField.getPassword()[i];
            t.append(response[i]);
        }
        this.password = t.toString();
        this.session.setPassword(t.toString());
        MyUserInfo ui = new MyUserInfo();
        this.session.setUserInfo(ui);
        try {
            this.session.connect();
        }
        catch (JSchException ex) {
            if (GlobalOptions.hasUI()) {
                JOptionPane.showMessageDialog(GlobalOptions.getUI(), "Unable to connect", "SSH error", 0);
                this.mysar.cleared();
            } else {
                log.error("Err: unable to connect");
            }
            return;
        }
        try {
            this.channel = this.session.openChannel("exec");
        }
        catch (JSchException ex) {
            if (GlobalOptions.hasUI()) {
                JOptionPane.showMessageDialog(GlobalOptions.getUI(), "Unable to open Channel", "SSH error", 0);
                this.mysar.cleared();
            } else {
                log.error("Err: unable to open Channel");
            }
            return;
        }
        ((ChannelExec)this.channel).setCommand("LC_ALL=C " + this.commandComboBox.getSelectedItem() + "\n");
        this.channel.setInputStream(null);
        this.channel.setXForwarding(false);
        try {
            this.in = this.channel.getInputStream();
            this.err = ((ChannelExec)this.channel).getErrStream();
        }
        catch (IOException ex) {
            if (GlobalOptions.hasUI()) {
                JOptionPane.showMessageDialog(GlobalOptions.getUI(), "Unable to open pipe", "SSH error", 0);
                this.mysar.cleared();
            } else {
                log.error("Err: unable to open pipe");
            }
            return;
        }
        try {
            this.channel.connect();
        }
        catch (JSchException ex) {
            if (GlobalOptions.hasUI()) {
                JOptionPane.showMessageDialog(GlobalOptions.getUI(), "Unable to connect Channel", "SSH error", 0);
                this.mysar.cleared();
            } else {
                log.error("Err: unable to connect Channel");
            }
            return;
        }
        if (this.channel.isClosed()) {
            log.info("exit {}", (Object)this.channel.getExitStatus());
            if (this.channel.getExitStatus() != 0) {
                if (GlobalOptions.hasUI()) {
                    JOptionPane.showMessageDialog(GlobalOptions.getUI(), "There was a problem while retrieving stat", "SSH error", 0);
                    this.mysar.cleared();
                } else {
                    log.error("Err: Problem during ssh connection");
                }
                return;
            }
        }
        this.command = tmp.getUsername() + "@" + tmp.getHostname() + "=" + this.commandComboBox.getSelectedItem();
        GlobalOptions.addHistory(tmp);
    }

    @Override
    public void run() {
        StringBuilder tmpmessage = new StringBuilder();
        try {
            String current_line;
            if (this.in == null) {
                return;
            }
            InputStreamReader tmpin = new InputStreamReader(this.in);
            InputStreamReader tmperr = new InputStreamReader(this.err);
            for (int max_waitdata = 10; max_waitdata > 0 && !tmpin.ready(); --max_waitdata) {
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            BufferedReader myfile = new BufferedReader(tmpin);
            BufferedReader myerror = new BufferedReader(tmperr);
            this.mysar.parse(myfile);
            while ((current_line = myerror.readLine()) != null) {
                tmpmessage.append(current_line);
                tmpmessage.append("\n");
            }
            if (tmpmessage.length() > 0 && GlobalOptions.hasUI()) {
                JOptionPane.showMessageDialog(GlobalOptions.getUI(), tmpmessage.toString(), "SSH error", 0);
            }
            myfile.close();
            myerror.close();
            tmpin.close();
            tmperr.close();
            this.in.close();
            this.err.close();
            this.channel.disconnect();
            this.session.disconnect();
            this.channel = null;
            this.session = null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            log.error("Exception", ex);
        }
    }

    public static class MyLogger
    implements Logger {
        static HashMap<Integer, String> name = new HashMap();

        @Override
        public boolean isEnabled(int level) {
            return true;
        }

        @Override
        public void log(int level, String message) {
            log.debug(name.get(new Integer(level)));
            log.debug(message);
        }

        static {
            name.put(new Integer(0), "DEBUG: ");
            name.put(new Integer(1), "INFO: ");
            name.put(new Integer(2), "WARN: ");
            name.put(new Integer(3), "ERROR: ");
            name.put(new Integer(4), "FATAL: ");
        }
    }

    public class MyUserInfo
    implements UserInfo,
    UIKeyboardInteractive {
        String passwd;
        JTextField passwordField = new JPasswordField(20);
        String passphrase;
        JTextField passphraseField = new JPasswordField(20);
        final GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
        private Container panel;

        @Override
        public boolean promptYesNo(String str) {
            Object[] options = new String[]{"yes", "no"};
            if (GlobalOptions.hasUI()) {
                int foo = JOptionPane.showOptionDialog(GlobalOptions.getUI(), str, "Warning", -1, 2, null, options, options[0]);
                return foo == 0;
            }
            return true;
        }

        @Override
        public String getPassphrase() {
            return this.passphrase;
        }

        @Override
        public boolean promptPassphrase(String message) {
            if (SSHCommand.this.num_try > 0) {
                Object[] ob = new Object[]{this.passphraseField};
                int result = JOptionPane.showConfirmDialog(GlobalOptions.getUI(), ob, message, 2);
                if (result == 0) {
                    this.passphrase = this.passphraseField.getText();
                    return true;
                }
                return false;
            }
            SSHCommand.this.num_try++;
            return true;
        }

        @Override
        public String getPassword() {
            if (SSHCommand.this.password != null) {
                return SSHCommand.this.password;
            }
            return this.passwd;
        }

        @Override
        public boolean promptPassword(String message) {
            if (SSHCommand.this.num_try > 0 || SSHCommand.this.password != null) {
                Object[] ob = new Object[]{this.passwordField};
                if (GlobalOptions.hasUI()) {
                    int result = JOptionPane.showConfirmDialog(GlobalOptions.getUI(), ob, message, 2);
                    if (result == 0) {
                        this.passwd = this.passwordField.getText();
                        return true;
                    }
                    return false;
                }
                return false;
            }
            SSHCommand.this.num_try++;
            return true;
        }

        @Override
        public String[] promptKeyboardInteractive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
            if (SSHCommand.this.password != null) {
                SSHCommand.this.num_try++;
                return SSHCommand.this.password.split("[.]");
            }
            this.panel = new JPanel();
            this.panel.setLayout(new GridBagLayout());
            this.gbc.weightx = 1.0;
            this.gbc.gridwidth = 0;
            this.gbc.gridx = 0;
            this.panel.add((Component)new JLabel(instruction), this.gbc);
            ++this.gbc.gridy;
            this.gbc.gridwidth = -1;
            JTextField[] texts = new JTextField[prompt.length];
            for (int i = 0; i < prompt.length; ++i) {
                this.gbc.fill = 0;
                this.gbc.gridx = 0;
                this.gbc.weightx = 1.0;
                this.panel.add((Component)new JLabel(prompt[i]), this.gbc);
                this.gbc.gridx = 1;
                this.gbc.fill = 2;
                this.gbc.weighty = 1.0;
                texts[i] = echo[i] ? new JTextField(20) : new JPasswordField(20);
                this.panel.add((Component)texts[i], this.gbc);
                ++this.gbc.gridy;
            }
            if (JOptionPane.showConfirmDialog(GlobalOptions.getUI(), this.panel, destination + " : " + name, 2, 3) == 0) {
                String[] response = new String[prompt.length];
                StringBuilder t = new StringBuilder();
                for (int i = 0; i < prompt.length; ++i) {
                    response[i] = texts[i].getText();
                    t.append(response[i]);
                }
                return response;
            }
            return null;
        }

        @Override
        public void showMessage(String message) {
            if (!GlobalOptions.hasUI()) {
                return;
            }
            JOptionPane.showMessageDialog(GlobalOptions.getUI(), message);
        }
    }
}

