/*
 * Decompiled with CFR 0.152.
 */
package net.atomique.ksar;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.atomique.ksar.GlobalOptions;
import net.atomique.ksar.xml.CnxHistory;
import net.atomique.ksar.xml.ColumnConfig;
import net.atomique.ksar.xml.GraphConfig;
import net.atomique.ksar.xml.HostInfo;
import net.atomique.ksar.xml.OSConfig;
import net.atomique.ksar.xml.PlotStackConfig;
import net.atomique.ksar.xml.StatConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLConfig
extends DefaultHandler {
    private static final String KSAR_DTD_PREFIX = "-//NET/ATOMIQUE/KSAR/";
    private static final Logger log = LoggerFactory.getLogger(XMLConfig.class);
    private boolean beenparse = false;
    private String tempval;
    private boolean in_color = false;
    private boolean in_colors = false;
    private boolean in_OS = false;
    private boolean in_history = false;
    private boolean in_cnx = false;
    private boolean in_hostinfo = false;
    private boolean in_host = false;
    private ColumnConfig currentColor = null;
    private OSConfig currentOS = null;
    private StatConfig currentStat = null;
    private GraphConfig currentGraph = null;
    private PlotStackConfig currentPlot = null;
    private PlotStackConfig currentStack = null;
    private CnxHistory currentCnx = null;
    private HostInfo currentHost = null;

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws IOException {
        if (publicId == null || !publicId.startsWith(KSAR_DTD_PREFIX)) {
            return null;
        }
        String dtdFile = publicId.substring(KSAR_DTD_PREFIX.length() - 1);
        dtdFile = dtdFile.toLowerCase();
        InputStream inputStream = this.getClass().getResourceAsStream(dtdFile);
        if (inputStream == null) {
            throw new FileNotFoundException("File " + publicId + " is not found in kSar resources");
        }
        return new InputSource(inputStream);
    }

    void loadFromResources(String fileName) {
        try (InputStream is = this.getClass().getResourceAsStream(fileName);){
            if (is == null) {
                throw new FileNotFoundException("File " + fileName + " is not found in kSar resources");
            }
            InputSource source = new InputSource(is);
            source.setPublicId(KSAR_DTD_PREFIX + fileName);
            this.loadConfig(source);
        }
        catch (IOException e) {
            log.warn("XML error while parsing " + fileName, e);
        }
    }

    void loadConfig(File file) {
        InputSource source = new InputSource(file.toURI().toASCIIString());
        this.loadConfig(source);
    }

    private void loadConfig(InputSource source) {
        String id = source.getSystemId() + " (" + source.getPublicId() + ")";
        try {
            SAXParserFactory fabric = SAXParserFactory.newInstance();
            SAXParser parser = fabric.newSAXParser();
            parser.parse(source, (DefaultHandler)this);
        }
        catch (ParserConfigurationException | SAXException ex) {
            log.warn("XML error while parsing " + id, ex);
        }
        catch (IOException ioe) {
            String msg = "IO exception while parsing " + id;
            log.error(msg, ioe);
            throw new IllegalArgumentException(msg, ioe);
        }
    }

    void dump_XML() {
        GlobalOptions.getOSlist().keySet().forEach(item -> {
            OSConfig tmp = GlobalOptions.getOSlist().get(item);
            log.trace("-OS-{}", (Object)tmp.getOsName());
            tmp.getStatHash().keySet().forEach(stat -> {
                StatConfig tmp2 = tmp.getStatHash().get(stat);
                log.trace("--STAT-- " + tmp2.getStatName() + "=> " + tmp2.getGraphName() + " " + tmp2.getHeaderStr());
            });
            tmp.getGraphHash().keySet().forEach(graph -> {
                GraphConfig tmp3 = tmp.getGraphHash().get(graph);
                log.trace("---GRAPH--- " + tmp3.getName() + "=> " + tmp3.getTitle());
                tmp3.getPlotlist().keySet().forEach(plot -> {
                    PlotStackConfig tmp4 = tmp3.getPlotlist().get(plot);
                    log.trace("----PLOT---- " + tmp4.getTitle() + "=> " + tmp4.getHeaderStr());
                });
            });
        });
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.tempval = new String(ch, start, length);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("colors".equals(qName)) {
            this.in_colors = true;
        }
        if ("OS".equals(qName)) {
            this.in_OS = true;
        }
        if ("History".equals(qName)) {
            this.in_history = true;
        }
        if ("HostInfo".equals(qName)) {
            this.in_hostinfo = true;
        }
        if (this.in_colors && "itemcolor".equals(qName)) {
            this.currentColor = new ColumnConfig(attributes.getValue("name"));
            this.in_color = true;
        }
        if (this.in_history && "cnx".equals(qName)) {
            this.currentCnx = new CnxHistory(attributes.getValue("link"));
            this.in_cnx = true;
        }
        if (this.in_hostinfo && "host".equals(qName)) {
            this.currentHost = new HostInfo(attributes.getValue("name"));
            this.in_host = true;
        }
        if (this.in_OS) {
            if ("OSType".equals(qName)) {
                this.currentOS = GlobalOptions.getOSlist().get(attributes.getValue("name"));
                if (this.currentOS == null) {
                    this.currentOS = new OSConfig(attributes.getValue("name"));
                    GlobalOptions.getOSlist().put(this.currentOS.getOsName(), this.currentOS);
                }
            }
            if (this.currentOS != null) {
                if ("Stat".equals(qName)) {
                    this.currentStat = new StatConfig(attributes.getValue("name"));
                    this.currentOS.addStat(this.currentStat);
                }
                if ("Graph".equals(qName)) {
                    this.currentGraph = new GraphConfig(attributes.getValue("name"), attributes.getValue("Title"), attributes.getValue("type"));
                    this.currentOS.addGraph(this.currentGraph);
                }
                if (this.currentGraph != null) {
                    String size_tmp;
                    if ("Plot".equals(qName)) {
                        this.currentPlot = new PlotStackConfig(attributes.getValue("Title"));
                        size_tmp = attributes.getValue("size");
                        if (size_tmp != null) {
                            this.currentPlot.setSize(size_tmp);
                        }
                        this.currentGraph.addPlot(this.currentPlot);
                    }
                    if ("Stack".equals(qName)) {
                        this.currentStack = new PlotStackConfig(attributes.getValue("Title"));
                        size_tmp = attributes.getValue("size");
                        if (size_tmp != null) {
                            this.currentStack.setSize(size_tmp);
                        }
                        this.currentGraph.addStack(this.currentStack);
                    }
                    if (this.currentPlot != null && "format".equals(qName)) {
                        this.currentPlot.setBase(attributes.getValue("base"));
                        this.currentPlot.setFactor(attributes.getValue("factor"));
                    }
                    if (this.currentStack != null && "format".equals(qName)) {
                        this.currentStack.setBase(attributes.getValue("base"));
                        this.currentStack.setFactor(attributes.getValue("factor"));
                    }
                }
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.tempval = this.tempval.trim();
        if ("ConfiG".equals(qName)) {
            this.beenparse = true;
        }
        if ("colors".equals(qName)) {
            this.in_colors = false;
        }
        if ("OSType".equals(qName)) {
            this.currentOS = null;
        }
        if ("Stat".equals(qName)) {
            this.currentStat = null;
        }
        if ("Graph".equals(qName)) {
            this.currentGraph = null;
        }
        if ("Cnx".equals(qName)) {
            this.currentCnx = null;
        }
        if ("Plot".equals(qName)) {
            this.currentPlot = null;
        }
        if ("Stack".equals(qName)) {
            this.currentStack = null;
        }
        if ("HostInfo".equals(qName)) {
            this.in_hostinfo = false;
        }
        if (this.currentStat != null) {
            if ("headerstr".equals(qName)) {
                this.currentStat.setHeaderStr(this.tempval);
            }
            if ("graphname".equals(qName)) {
                this.currentStat.setGraphName(this.tempval);
            }
            if ("duplicate".equals(qName)) {
                this.currentStat.setDuplicateTime(this.tempval);
            }
        }
        if ("cols".equals(qName)) {
            if (this.currentPlot != null) {
                this.currentPlot.setHeaderStr(this.tempval);
            }
            if (this.currentStack != null) {
                this.currentStack.setHeaderStr(this.tempval);
            }
        }
        if ("range".equals(qName)) {
            if (this.currentPlot != null) {
                this.currentPlot.setRange(this.tempval);
            }
            if (this.currentStack != null) {
                this.currentStack.setRange(this.tempval);
            }
        }
        if ("itemcolor".equals(qName)) {
            if (this.currentColor.is_valid()) {
                GlobalOptions.getColorlist().put(this.currentColor.getData_title(), this.currentColor);
            } else {
                this.currentColor = null;
            }
            this.in_color = false;
        }
        if (this.in_color && "color".equals(qName) && this.currentColor != null) {
            this.currentColor.setData_color(this.tempval);
        }
        if (this.in_cnx && "command".equals(qName) && this.currentCnx != null) {
            this.currentCnx.addCommand(this.tempval);
        }
        if ("cnx".equals(qName)) {
            if (this.currentCnx.isValid()) {
                GlobalOptions.getHistoryList().put(this.currentCnx.getLink(), this.currentCnx);
            } else {
                log.error("Err cnx is not valid");
                this.currentCnx = null;
            }
        }
        if (this.in_hostinfo) {
            if ("alias".equals(qName)) {
                this.currentHost.setAlias(this.tempval);
            }
            if ("description".equals(qName)) {
                this.currentHost.setDescription(this.tempval);
            }
            if ("memblocksize".equals(qName)) {
                this.currentHost.setMemBlockSize(this.tempval);
            }
        }
        if ("host".equals(qName)) {
            GlobalOptions.getHostInfoList().put(this.currentHost.getHostname(), this.currentHost);
            this.currentHost = null;
        }
    }
}

