/*
 * Decompiled with CFR 0.152.
 */
package net.atomique.ksar.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JCheckBox;
import net.atomique.ksar.Config;
import net.atomique.ksar.GlobalOptions;
import net.atomique.ksar.kSar;
import net.atomique.ksar.ui.SortedTreeNode;
import net.atomique.ksar.ui.TreeNodeInfo;
import net.atomique.ksar.xml.ColumnConfig;
import net.atomique.ksar.xml.GraphConfig;
import net.atomique.ksar.xml.PlotStackConfig;
import net.atomique.ksar.xml.StatConfig;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartUtils;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StackedXYAreaRenderer2;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.data.general.SeriesException;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.TimeTableXYDataset;
import org.jfree.data.xy.XYDataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Graph {
    private static final Logger log = LoggerFactory.getLogger(Graph.class);
    private DateAxis axisofdate = new DateAxis("");
    private kSar mysar = null;
    private JFreeChart mygraph = null;
    private ChartPanel chartpanel = null;
    private String graphtitle = null;
    private boolean printSelected = true;
    private JCheckBox printCheckBox = null;
    private GraphConfig graphconfig = null;
    private int firstDataColumn = 0;
    private String[] HeaderStr = null;
    private ArrayList<TimeSeries> Stats = new ArrayList();
    private Map<String, TimeTableXYDataset> StackListbyName = new HashMap<String, TimeTableXYDataset>();
    private Map<String, TimeTableXYDataset> StackListbyCol = new HashMap<String, TimeTableXYDataset>();

    public Graph(kSar hissar, GraphConfig g, String Title2, String hdrs, int firstdatacolumn, SortedTreeNode pp) {
        this.mysar = hissar;
        this.graphtitle = Title2;
        this.graphconfig = g;
        this.printCheckBox = new JCheckBox(this.graphtitle, this.printSelected);
        this.printCheckBox.addItemListener(evt -> {
            if (evt.getSource() == this.printCheckBox) {
                this.printSelected = this.printCheckBox.isSelected();
            }
        });
        this.firstDataColumn = firstdatacolumn;
        if (pp != null) {
            TreeNodeInfo infotmp = new TreeNodeInfo(Title2, this);
            SortedTreeNode nodetmp = new SortedTreeNode(infotmp);
            this.mysar.add2tree(pp, nodetmp);
        }
        this.HeaderStr = hdrs.split("\\s+");
        this.create_DataStore();
    }

    private void create_DataStore() {
        for (int i = this.firstDataColumn; i < this.HeaderStr.length; ++i) {
            this.Stats.add(new TimeSeries((Comparable)((Object)this.HeaderStr[i])));
        }
        for (PlotStackConfig tmp : this.graphconfig.getStacklist().values()) {
            String[] s;
            TimeTableXYDataset tmp2 = new TimeTableXYDataset();
            for (String value : s = tmp.getHeaderStr().split("\\s+")) {
                this.StackListbyCol.put(value, tmp2);
            }
            this.StackListbyName.put(tmp.getTitle(), tmp2);
        }
    }

    public int parse_line(LocalDateTime ldt, String s) {
        Second now = new Second(ldt.getSecond(), ldt.getMinute(), ldt.getHour(), ldt.getDayOfMonth(), ldt.getMonthValue(), ldt.getYear());
        this.parse_line(now, s);
        return 0;
    }

    public int parse_line(Second now, String s) {
        String[] cols = s.split("\\s+");
        for (int i = this.firstDataColumn; i < this.HeaderStr.length; ++i) {
            double colvalue;
            try {
                colvalue = Double.parseDouble(cols[i]);
            }
            catch (NumberFormatException ne) {
                log.error("{} {} is NaN", (Object)this.graphtitle, (Object)cols[i]);
                return 0;
            }
            catch (ArrayIndexOutOfBoundsException aie) {
                log.error("{} col {} is missing {}", this.graphtitle, i, s);
                return 0;
            }
            catch (Exception ae) {
                log.error("{} {} is undef {}", this.graphtitle, cols[i], s);
                ae.printStackTrace();
                return 0;
            }
            this.add_datapoint_plot(now, i - this.firstDataColumn, this.HeaderStr[i - this.firstDataColumn], colvalue);
            TimeTableXYDataset tmp = this.StackListbyCol.get(this.HeaderStr[i]);
            if (tmp == null) continue;
            this.add_datapoint_stack(tmp, now, i, this.HeaderStr[i], colvalue);
        }
        return 0;
    }

    private boolean add_datapoint_stack(TimeTableXYDataset dataset, Second now, int col, String colheader, double value) {
        try {
            dataset.add(now, value, (Comparable)((Object)colheader));
            return true;
        }
        catch (SeriesException se) {
            return false;
        }
    }

    private boolean add_datapoint_plot(Second now, int col, String colheader, double value) {
        try {
            this.Stats.get(col).add((RegularTimePeriod)now, value);
            return true;
        }
        catch (SeriesException se) {
            StatConfig statconfig = this.mysar.myparser.get_OSConfig().getStat(this.mysar.myparser.getCurrentStat());
            if (statconfig != null && statconfig.canDuplicateTime()) {
                double tempval;
                Number oldval = this.Stats.get(col).getValue(now);
                if (oldval == null) {
                    return false;
                }
                ColumnConfig colconfig = GlobalOptions.getColumnConfig(colheader);
                if (colconfig == null) {
                    return false;
                }
                if (colconfig.getType() == 1) {
                    tempval = (oldval.doubleValue() + value) / 2.0;
                } else if (colconfig.getType() == 2) {
                    tempval = oldval.doubleValue() + value;
                } else {
                    return false;
                }
                try {
                    this.Stats.get(col).update((RegularTimePeriod)now, tempval);
                    return true;
                }
                catch (SeriesException se2) {
                    return false;
                }
            }
            return false;
        }
    }

    public String make_csv() {
        StringBuilder tmp = new StringBuilder();
        tmp.append("Date;");
        tmp.append(this.getCsvHeader());
        tmp.append("\n");
        TimeSeries datelist = this.Stats.get(0);
        for (TimePeriod item : datelist.getTimePeriods()) {
            tmp.append(item.toString());
            tmp.append(";");
            tmp.append(this.getCsvLine((RegularTimePeriod)item));
            tmp.append("\n");
        }
        return tmp.toString();
    }

    public String getCsvHeader() {
        StringBuilder tmp = new StringBuilder();
        for (int i = this.firstDataColumn; i < this.HeaderStr.length; ++i) {
            TimeSeries tmpseries = this.Stats.get(i - this.firstDataColumn);
            tmp.append(this.graphtitle).append(" ").append(tmpseries.getKey());
            tmp.append(";");
        }
        return tmp.toString();
    }

    public String getCsvLine(RegularTimePeriod t) {
        StringBuilder tmp = new StringBuilder();
        for (int i = this.firstDataColumn; i < this.HeaderStr.length; ++i) {
            TimeSeries tmpseries = this.Stats.get(i - this.firstDataColumn);
            tmp.append(tmpseries.getValue(t));
            tmp.append(";");
        }
        return tmp.toString();
    }

    public int savePNG(String filename, int width, int height) {
        try {
            ChartUtils.saveChartAsPNG(new File(filename), this.getgraph(this.mysar.myparser.getStartOfGraph(), this.mysar.myparser.getEndOfGraph()), width, height);
        }
        catch (IOException e) {
            log.error("Unable to write to : {}", (Object)filename);
            return -1;
        }
        return 0;
    }

    public int saveJPG(String filename, int width, int height) {
        try {
            ChartUtils.saveChartAsJPEG(new File(filename), this.getgraph(this.mysar.myparser.getStartOfGraph(), this.mysar.myparser.getEndOfGraph()), width, height);
        }
        catch (IOException e) {
            log.error("Unable to write to : {}", (Object)filename);
            return -1;
        }
        return 0;
    }

    public JCheckBox getprintform() {
        return this.printCheckBox;
    }

    public boolean doPrint() {
        return this.printSelected;
    }

    public JFreeChart getgraph(LocalDateTime start, LocalDateTime end) {
        if (this.mygraph == null) {
            this.mygraph = this.makegraph(start, end);
        } else {
            Date getStartofGraphStart = this.convertLocalDateTimeToSecond(this.mysar.myparser.getStartOfGraph()).getStart();
            Date GetEndofGraphEnd = this.convertLocalDateTimeToSecond(this.mysar.myparser.getEndOfGraph()).getEnd();
            if (!this.axisofdate.getMinimumDate().equals(getStartofGraphStart)) {
                this.axisofdate.setMinimumDate(getStartofGraphStart);
            }
            if (!this.axisofdate.getMaximumDate().equals(GetEndofGraphEnd)) {
                this.axisofdate.setMaximumDate(GetEndofGraphEnd);
            }
        }
        return this.mygraph;
    }

    public String getTitle() {
        return this.graphtitle;
    }

    public boolean isPrintSelected() {
        return this.printSelected;
    }

    private XYDataset create_collection(ArrayList l) {
        TimeSeriesCollection graphcollection = new TimeSeriesCollection();
        boolean hasdata = false;
        for (int i = 0; i < l.size(); ++i) {
            TimeSeries found = null;
            for (int j = 0; j < this.Stats.size() && !(found = this.Stats.get(j)).getKey().equals(l.get(i)); ++j) {
                found = null;
            }
            if (found == null) continue;
            graphcollection.addSeries(found);
            hasdata = true;
        }
        if (!hasdata) {
            return null;
        }
        return graphcollection;
    }

    public ChartPanel get_ChartPanel() {
        if (this.chartpanel == null) {
            this.chartpanel = this.mysar.isParsing() ? new ChartPanel(this.getgraph(null, null)) : new ChartPanel(this.getgraph(this.mysar.myparser.getStartOfGraph(), this.mysar.myparser.getEndOfGraph()));
        } else if (!this.mysar.isParsing()) {
            Date getStartofGraphStart = this.convertLocalDateTimeToSecond(this.mysar.myparser.getStartOfGraph()).getStart();
            Date GetEndofGraphEnd = this.convertLocalDateTimeToSecond(this.mysar.myparser.getEndOfGraph()).getEnd();
            if (!this.axisofdate.getMinimumDate().equals(getStartofGraphStart)) {
                this.axisofdate.setMinimumDate(getStartofGraphStart);
            }
            if (!this.axisofdate.getMaximumDate().equals(GetEndofGraphEnd)) {
                this.axisofdate.setMaximumDate(GetEndofGraphEnd);
            }
        }
        return this.chartpanel;
    }

    private JFreeChart makegraph(LocalDateTime start, LocalDateTime end) {
        long begingenerate = System.currentTimeMillis();
        CombinedDomainXYPlot plot = new CombinedDomainXYPlot(this.axisofdate);
        for (PlotStackConfig tmp : this.graphconfig.getStacklist().values()) {
            TimeTableXYDataset tmp2;
            if (tmp == null || (tmp2 = this.StackListbyName.get(tmp.getTitle())) == null) continue;
            StackedXYAreaRenderer2 renderer = new StackedXYAreaRenderer2();
            NumberAxis graphaxistitle = tmp.getAxis();
            XYPlot temp_plot = new XYPlot(tmp2, this.axisofdate, graphaxistitle, renderer);
            for (int i = 0; i < tmp2.getSeriesCount(); ++i) {
                Color color = GlobalOptions.getDataColor(tmp2.getSeriesKey(i).toString());
                if (color == null) continue;
                renderer.setSeriesPaint(i, color);
                renderer.setDefaultStroke(new BasicStroke(1.0f));
            }
            plot.add(temp_plot, tmp.getSize());
        }
        for (PlotStackConfig tmp : this.graphconfig.getPlotlist().values()) {
            StandardXYItemRenderer renderer = new StandardXYItemRenderer();
            ArrayList t = new ArrayList();
            String[] s = tmp.getHeaderStr().split("\\s+");
            Collections.addAll(t, s);
            XYDataset c = this.create_collection(t);
            NumberAxis graphaxistitle = tmp.getAxis();
            XYPlot tmpplot = new XYPlot(c, this.axisofdate, graphaxistitle, renderer);
            for (int i = 0; i < s.length; ++i) {
                Color color = GlobalOptions.getDataColor(s[i]);
                if (color == null) continue;
                renderer.setSeriesPaint(i, color);
                renderer.setDefaultStroke(new BasicStroke(1.0f));
            }
            plot.add(tmpplot, tmp.getSize());
        }
        if (plot.getSubplots().isEmpty()) {
            return null;
        }
        if (start != null && end != null) {
            Second g_start = this.convertLocalDateTimeToSecond(start);
            Second g_end = this.convertLocalDateTimeToSecond(end);
            this.axisofdate.setRange(g_start.getStart(), g_end.getEnd());
        }
        plot.setOrientation(PlotOrientation.VERTICAL);
        JFreeChart mychart = new JFreeChart(this.graphtitle, Config.getDEFAULT_FONT(), plot, true);
        long endgenerate = System.currentTimeMillis();
        mychart.setBackgroundPaint(Color.white);
        if (GlobalOptions.isDodebug()) {
            log.debug("graph generation: {} ms", (Object)(endgenerate - begingenerate));
        }
        return mychart;
    }

    private Second convertLocalDateTimeToSecond(LocalDateTime ldt) {
        int day = ldt.getDayOfMonth();
        int month = ldt.getMonthValue();
        int year = ldt.getYear();
        int hour = ldt.getHour();
        int minute = ldt.getMinute();
        int second = ldt.getSecond();
        return new Second(second, minute, hour, day, month, year);
    }
}

