/*
 * Decompiled with CFR 0.152.
 */
package net.atomique.ksar.graph;

import java.awt.GridLayout;
import java.time.LocalDateTime;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import net.atomique.ksar.graph.Graph;
import net.atomique.ksar.kSar;
import net.atomique.ksar.ui.NaturalComparator;
import net.atomique.ksar.ui.ParentNodeInfo;
import net.atomique.ksar.ui.SortedTreeNode;
import net.atomique.ksar.ui.TreeNodeInfo;
import net.atomique.ksar.xml.GraphConfig;
import org.jfree.data.time.Second;

public class List {
    protected GraphConfig graphconfig = null;
    protected SortedTreeNode parentTreeNode = null;
    protected kSar mysar = null;
    protected String HeaderStr = null;
    protected SortedMap<String, Graph> nodeHashList = new TreeMap<String, Graph>(NaturalComparator.NULLS_FIRST);
    protected int FirstDataColumn = 0;
    protected String Title = null;

    public List(kSar hissar, GraphConfig g, String stitle, String sheader, int firstdatacolumn) {
        this.mysar = hissar;
        this.HeaderStr = sheader;
        this.graphconfig = g;
        this.Title = stitle;
        this.FirstDataColumn = firstdatacolumn;
        ParentNodeInfo tmp = new ParentNodeInfo(this.Title, this);
        this.parentTreeNode = new SortedTreeNode(tmp);
        this.mysar.add2tree(this.mysar.graphtree, this.parentTreeNode);
    }

    public int parse_line(LocalDateTime ldt, String s) {
        Second now = new Second(ldt.getSecond(), ldt.getMinute(), ldt.getHour(), ldt.getDayOfMonth(), ldt.getMonthValue(), ldt.getYear());
        return this.parse_line(now, s);
    }

    public int parse_line(Second now, String s) {
        Graph tmp;
        String[] cols = s.split("\\s+");
        if (!this.nodeHashList.containsKey(cols[this.FirstDataColumn])) {
            tmp = new Graph(this.mysar, this.graphconfig, this.Title + " " + cols[this.FirstDataColumn], this.HeaderStr, this.FirstDataColumn + 1, null);
            this.nodeHashList.put(cols[this.FirstDataColumn], tmp);
            TreeNodeInfo infotmp = new TreeNodeInfo(cols[this.FirstDataColumn], tmp);
            SortedTreeNode nodetmp = new SortedTreeNode(infotmp);
            this.mysar.add2tree(this.parentTreeNode, nodetmp);
        } else {
            tmp = (Graph)this.nodeHashList.get(cols[this.FirstDataColumn]);
        }
        return tmp.parse_line(now, s);
    }

    public JPanel run() {
        JPanel tmppanel = new JPanel();
        int graphnumber = this.nodeHashList.size();
        int linenum = (int)Math.floor(graphnumber / 2);
        if (graphnumber % 2 != 0) {
            ++linenum;
        }
        GridLayout tmplayout = new GridLayout(linenum, 2);
        tmppanel.setLayout(tmplayout);
        for (Graph graph : this.nodeHashList.values()) {
            tmppanel.add(graph.get_ChartPanel());
        }
        return tmppanel;
    }

    public boolean isPrintSelected() {
        boolean leaftoprint = false;
        for (Graph graph : this.nodeHashList.values()) {
            if (!graph.isPrintSelected()) continue;
            leaftoprint = true;
            break;
        }
        return leaftoprint;
    }

    public String getTitle() {
        return this.Title;
    }

    public JPanel getprintform() {
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder(this.Title));
        panel.setLayout(new BoxLayout(panel, 3));
        return panel;
    }
}

