/*
 * Decompiled with CFR 0.152.
 */
package net.atomique.ksar.parser;

import java.awt.Frame;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import net.atomique.ksar.Config;
import net.atomique.ksar.GlobalOptions;
import net.atomique.ksar.OSParser;
import net.atomique.ksar.graph.Graph;
import net.atomique.ksar.graph.List;
import net.atomique.ksar.ui.LinuxDateFormat;
import net.atomique.ksar.xml.GraphConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Linux
extends OSParser {
    private static final Logger log = LoggerFactory.getLogger(Linux.class);
    private String LinuxDateFormat;
    private final HashSet<String> IgnoreLinesBeginningWith = new HashSet<String>(Arrays.asList("Average:", "##", "Summary", "Summary:"));

    @Override
    public void parse_header(String s) {
        log.debug("Header Line : {}", (Object)s);
        String[] columns = s.split("\\s+");
        this.setOstype(columns[0]);
        this.setKernel(columns[1]);
        String tmpstr = columns[2];
        this.setHostname(tmpstr.substring(1, tmpstr.length() - 1));
        this.checkDateFormat();
        this.setDate(columns[3]);
    }

    private void checkDateFormat() {
        this.LinuxDateFormat = Config.getLinuxDateFormat();
        if ("Always ask".equals(this.LinuxDateFormat)) {
            this.askDateFormat();
        }
        if ("Automatic Detection".equals(this.LinuxDateFormat)) {
            this.dateFormat = "Automatic Detection";
            this.timeColumn = 0;
        } else {
            String[] parts = this.LinuxDateFormat.split(" ", 3);
            this.dateFormat = parts[0];
            this.dateFormat = this.dateFormat.replaceAll("D{2}", "dd");
            this.dateFormat = this.dateFormat.replaceAll("Y{2}", "yy");
            if (parts.length == 3 && parts[2].contains("AM|PM")) {
                this.timeFormat = "hh:mm:ss a";
                this.timeColumn = 2;
            }
        }
        log.debug("Date Format: {}, Time Format: {}", (Object)this.dateFormat, (Object)this.timeFormat);
    }

    private void askDateFormat() {
        log.trace("askDateFormat - provide date format");
        if (GlobalOptions.hasUI()) {
            LinuxDateFormat tmp = new LinuxDateFormat((Frame)GlobalOptions.getUI(), true);
            tmp.setTitle("Provide date format");
            if (tmp.isOk()) {
                this.LinuxDateFormat = tmp.getDateFormat();
                if (tmp.hasToRemenber()) {
                    Config.setLinuxDateFormat(tmp.getDateFormat());
                    Config.save();
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int parse(String line, String[] columns) {
        Object ag;
        if (this.IgnoreLinesBeginningWith.contains(columns[0])) {
            this.currentStat = "NONE";
            return 0;
        }
        if (line.contains("LINUX RESTART")) {
            return 0;
        }
        try {
            DateTimeFormatter formatter;
            if (this.timeColumn == 0) {
                if ((columns[0] + " " + columns[1]).matches("^\\d\\d:\\d\\d:\\d\\d [AP]M$")) {
                    this.timeFormat = "hh:mm:ss a";
                    this.timeColumn = 2;
                } else {
                    this.timeColumn = 1;
                }
            }
            if (this.timeColumn == 2) {
                formatter = DateTimeFormatter.ofPattern(this.timeFormat, Locale.US);
                this.parsetime = LocalTime.parse(columns[0] + " " + columns[1], formatter);
            } else {
                formatter = DateTimeFormatter.ofPattern(this.timeFormat);
                this.parsetime = LocalTime.parse(columns[0], formatter);
            }
            if (this.parsedate == null || this.parsetime == null) {
                throw new IllegalArgumentException("date/time is missing");
            }
            LocalDateTime nowStat = LocalDateTime.of(this.parsedate, this.parsetime);
            this.setStartAndEndOfGraph(nowStat);
            this.firstdatacolumn = this.timeColumn;
        }
        catch (IllegalArgumentException | DateTimeParseException ex) {
            log.error("unable to parse time {}", (Object)columns[0], (Object)ex);
            return -1;
        }
        if ("CPU".equals(columns[this.firstdatacolumn]) && line.matches(".*i([0-9]+)/s.*")) {
            this.currentStat = "IGNORE";
            return 1;
        }
        String checkStat = this.myosconfig.getStat(columns, this.firstdatacolumn);
        if (checkStat != null) {
            Object v = this.ListofGraph.get(checkStat);
            if (v != null) {
                this.currentStat = checkStat;
                return 0;
            }
            GraphConfig mygraphinfo = this.myosconfig.getGraphConfig(checkStat);
            if (mygraphinfo == null) {
                this.currentStat = checkStat;
                return 0;
            }
            if ("unique".equals(mygraphinfo.getType())) {
                Graph graph = new Graph(this.mysar, mygraphinfo, mygraphinfo.getTitle(), line, this.firstdatacolumn, this.mysar.graphtree);
                this.ListofGraph.put(checkStat, graph);
                this.currentStat = checkStat;
                return 0;
            }
            if ("multiple".equals(mygraphinfo.getType())) {
                List list = new List(this.mysar, mygraphinfo, mygraphinfo.getTitle(), line, this.firstdatacolumn);
                this.ListofGraph.put(checkStat, list);
                this.currentStat = checkStat;
                return 0;
            }
        }
        if (this.lastStat != null) {
            if (!this.lastStat.equals(this.currentStat)) {
                if (GlobalOptions.isDodebug()) {
                    log.debug("Stat change from {} to {}", (Object)this.lastStat, (Object)this.currentStat);
                }
                this.lastStat = this.currentStat;
            }
        } else {
            this.lastStat = this.currentStat;
        }
        if ("IGNORE".equals(this.currentStat)) {
            return 1;
        }
        if ("NONE".equals(this.currentStat)) {
            return -1;
        }
        this.currentStatObj = this.ListofGraph.get(this.currentStat);
        if (this.currentStatObj == null) {
            return -1;
        }
        LocalDateTime localDateTime = LocalDateTime.of(this.parsedate, this.parsetime);
        this.DateSamples.add(localDateTime);
        if (this.currentStatObj instanceof Graph) {
            ag = (Graph)this.currentStatObj;
            return ((Graph)ag).parse_line(localDateTime, line);
        }
        if (this.currentStatObj instanceof List) {
            ag = (List)this.currentStatObj;
            return ((List)ag).parse_line(localDateTime, line);
        }
        return -1;
    }
}

