/*
 * Decompiled with CFR 0.152.
 */
package net.atomique.ksar.xml;

import java.awt.Color;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnConfig {
    private static final Logger log = LoggerFactory.getLogger(ColumnConfig.class);
    private int type = 0;
    private Color data_color = null;
    private String data_title;

    public ColumnConfig(String s) {
        this.data_title = s;
    }

    public void setData_color(String dataColorString) {
        String[] color_indices = dataColorString.split(",");
        if (color_indices.length == 3) {
            try {
                this.data_color = new Color(Integer.parseInt(color_indices[0]), Integer.parseInt(color_indices[1]), Integer.parseInt(color_indices[2]));
            }
            catch (IllegalArgumentException iae) {
                log.warn("Column color error for {} - <{}>", this.data_title, dataColorString, iae);
            }
        } else {
            log.warn("Wrong Color definition for {} - <{}>", (Object)this.data_title, (Object)dataColorString);
        }
    }

    public Color getData_color() {
        return this.data_color;
    }

    public String getData_title() {
        return this.data_title;
    }

    public void setType(String s) {
        if ("gauge".equals(s)) {
            this.type = 1;
        }
        if ("counter".equals(s)) {
            this.type = 2;
        }
    }

    public int getType() {
        return this.type;
    }

    public boolean is_valid() {
        return this.data_color != null;
    }
}

