/*
 * Decompiled with CFR 0.152.
 */
package net.atomique.ksar.xml;

import java.util.Arrays;
import java.util.HashMap;
import net.atomique.ksar.xml.GraphConfig;
import net.atomique.ksar.xml.StatConfig;

public class OSConfig {
    private String OsName = null;
    private HashMap<String, StatConfig> StatHash = new HashMap();
    private HashMap<String, GraphConfig> GraphHash = new HashMap();
    private HashMap<String, String> MappingStatHeaderName;

    public OSConfig(String s) {
        this.OsName = s;
    }

    public void addStat(StatConfig s) {
        this.StatHash.put(s.getStatName(), s);
    }

    public void addGraph(GraphConfig s) {
        this.GraphHash.put(s.getName(), s);
    }

    public String getOsName() {
        return this.OsName;
    }

    public String getStat(String[] columns, int firstdatacolumn) {
        CharSequence[] s1 = Arrays.copyOfRange(columns, firstdatacolumn, columns.length);
        String header = String.join((CharSequence)" ", s1);
        this.createCacheForMappingOfHeaderStr2StatName();
        String statName = this.MappingStatHeaderName.get(header);
        if (statName != null) {
            return this.StatHash.get(statName).getGraphName();
        }
        return null;
    }

    private void createCacheForMappingOfHeaderStr2StatName() {
        if (this.MappingStatHeaderName == null) {
            this.MappingStatHeaderName = new HashMap();
            this.StatHash.forEach((k, v) -> {
                String statName = v.getStatName();
                String graphHeader = v.getHeaderStr();
                this.MappingStatHeaderName.put(graphHeader, statName);
            });
        }
    }

    public StatConfig getStat(String statName) {
        if (this.StatHash.isEmpty()) {
            return null;
        }
        StatConfig[] result = new StatConfig[]{null};
        this.StatHash.keySet().forEach(item -> {
            StatConfig tmp = this.StatHash.get(item);
            if (tmp.getGraphName().equals(statName)) {
                result[0] = tmp;
            }
        });
        return result[0];
    }

    public GraphConfig getGraphConfig(String s) {
        if (this.GraphHash.isEmpty()) {
            return null;
        }
        return this.GraphHash.get(s);
    }

    public HashMap<String, StatConfig> getStatHash() {
        return this.StatHash;
    }

    public HashMap<String, GraphConfig> getGraphHash() {
        return this.GraphHash;
    }
}

