/*
 * Decompiled with CFR 0.152.
 */
package net.atomique.ksar.xml;

import net.atomique.ksar.graph.IEEE1541Number;
import net.atomique.ksar.graph.ISNumber;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.data.Range;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlotStackConfig {
    private static final Logger log = LoggerFactory.getLogger(PlotStackConfig.class);
    private Double factor = null;
    private int base = 0;
    private Range range = null;
    private int size = 1;
    private String Title = null;
    private String[] Header = null;
    private String HeaderStr = null;

    public PlotStackConfig(String s) {
        this.Title = s;
    }

    public String[] getHeader() {
        return this.Header;
    }

    public String getTitle() {
        return this.Title;
    }

    public void setHeaderStr(String s) {
        this.Header = s.split("\\s+");
        this.HeaderStr = s;
    }

    public String getHeaderStr() {
        return this.HeaderStr;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setSize(String s) {
        Integer tmp = new Integer(s);
        if (tmp == null) {
            return;
        }
        this.size = tmp;
    }

    public NumberAxis getAxis() {
        NumberAxis tmp = new NumberAxis(this.Title);
        if (this.base == 1024) {
            IEEE1541Number decimalformat1 = new IEEE1541Number(this.factor.intValue());
            tmp.setNumberFormatOverride(decimalformat1);
        } else if (this.base == 1000) {
            ISNumber decimalformat1 = new ISNumber(this.factor.intValue());
            tmp.setNumberFormatOverride(decimalformat1);
        } else if (this.base != 0) {
            log.error("base value is not handled");
        }
        if (this.range != null) {
            tmp.setRange(this.range);
        }
        return tmp;
    }

    public void setBase(String s) {
        if (s == null) {
            return;
        }
        this.base = Integer.parseUnsignedInt(s);
    }

    public void setFactor(String s) {
        this.factor = Double.parseDouble(s);
    }

    public void setRange(String s) {
        String[] t = s.split(",");
        if (t.length == 2) {
            Double min = Double.parseDouble(t[0]);
            Double max = Double.parseDouble(t[1]);
            this.range = new Range(min, max);
        }
    }
}

