/*
 * Decompiled with CFR 0.152.
 */
package net.atomique.ksar;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import net.atomique.ksar.kSar;
import net.atomique.ksar.xml.OSConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AllParser {
    private static final Logger log = LoggerFactory.getLogger(AllParser.class);
    private static final Map<String, String> DATE_FORMAT_REGEXPS = new HashMap<String, String>(){
        {
            this.put("^\\d{8}$", "yyyyMMdd");
            this.put("^\\d{1,2}-\\d{1,2}-\\d{4}$", "dd-MM-yyyy");
            this.put("^\\d{4}-\\d{1,2}-\\d{1,2}$", "yyyy-MM-dd");
            this.put("^\\d{1,2}/\\d{1,2}/\\d{4}$", "MM/dd/yyyy");
            this.put("^\\d{4}/\\d{1,2}/\\d{1,2}$", "yyyy/MM/dd");
            this.put("^\\d{1,2}\\s[a-z]{3}\\s\\d{4}$", "dd MMM yyyy");
            this.put("^\\d{1,2}\\s[a-z]{4,}\\s\\d{4}$", "dd MMMM yyyy");
            this.put("^\\d{1,2}-\\d{1,2}-\\d{2}$", "dd-MM-yy");
            this.put("^\\d{1,2}/\\d{1,2}/\\d{2}$", "MM/dd/yy");
        }
    };
    protected String sarStartDate = null;
    protected String sarEndDate = null;
    private LocalDateTime startOfGraph = null;
    private LocalDateTime endOfGraph = null;
    protected TreeSet<LocalDateTime> DateSamples = new TreeSet();
    protected int firstdatacolumn = 0;
    protected kSar mysar = null;
    protected OSConfig myosconfig = null;
    protected String ParserName = null;
    protected LocalTime parsetime = null;
    protected LocalDate parsedate = null;
    protected String currentStat = "NONE";
    protected String dateFormat = "MM/dd/yy";
    protected String timeFormat = "HH:mm:ss";
    protected int timeColumn = 1;

    public AllParser() {
    }

    public void init(kSar hissar, String header) {
        String[] s = header.split("\\s+");
        this.mysar = hissar;
        this.ParserName = s[0];
        this.parse_header(header);
    }

    public AllParser(kSar hissar, String header) {
        this.init(hissar, header);
    }

    public int parse(String line, String[] columns) {
        log.error("not implemented");
        return -1;
    }

    protected void setStartAndEndOfGraph(LocalDateTime nowStat) {
        if (this.startOfGraph == null) {
            this.startOfGraph = nowStat;
        }
        if (this.endOfGraph == null) {
            this.endOfGraph = nowStat;
        }
        if (nowStat.compareTo(this.startOfGraph) < 0) {
            this.startOfGraph = nowStat;
        }
        if (nowStat.compareTo(this.endOfGraph) > 0) {
            this.endOfGraph = nowStat;
        }
    }

    public LocalDateTime getStartOfGraph() {
        return this.startOfGraph;
    }

    public LocalDateTime getEndOfGraph() {
        return this.endOfGraph;
    }

    public String getParserName() {
        return this.ParserName;
    }

    public boolean setDate(String s) {
        LocalDate endDate;
        LocalDate startDate;
        LocalDate currentDate;
        if (this.sarStartDate == null) {
            this.sarStartDate = s;
        }
        if (this.sarEndDate == null) {
            this.sarEndDate = s;
        }
        try {
            DateTimeFormatter formatter = "Automatic Detection".equals(this.dateFormat) ? DateTimeFormatter.ofPattern(AllParser.determineDateFormat(s)) : DateTimeFormatter.ofPattern(this.dateFormat);
            log.debug("Date formatter: {}", (Object)formatter);
            currentDate = LocalDate.parse(s, formatter);
            startDate = LocalDate.parse(this.sarStartDate, formatter);
            endDate = LocalDate.parse(this.sarEndDate, formatter);
        }
        catch (DateTimeParseException ex) {
            log.error("unable to parse date {}", (Object)s, (Object)ex);
            return false;
        }
        this.parsedate = currentDate;
        if (currentDate.compareTo(startDate) < 0) {
            this.sarStartDate = s;
        }
        if (currentDate.compareTo(endDate) > 0) {
            this.sarEndDate = s;
        }
        log.debug("parsedDate: {}, startDate: {}, EndDate: {}", currentDate, this.sarStartDate, this.sarEndDate);
        return true;
    }

    public String getDate() {
        if (this.sarStartDate.equals(this.sarEndDate)) {
            return this.sarStartDate;
        }
        return this.sarStartDate + " to " + this.sarEndDate;
    }

    public TreeSet<LocalDateTime> getDateSamples() {
        return this.DateSamples;
    }

    public String getCurrentStat() {
        return this.currentStat;
    }

    public static String determineDateFormat(String dateString) {
        for (String regexp : DATE_FORMAT_REGEXPS.keySet()) {
            if (!dateString.toLowerCase().matches(regexp)) continue;
            return DATE_FORMAT_REGEXPS.get(regexp);
        }
        return null;
    }

    public abstract String getInfo();

    public abstract void parse_header(String var1);

    public abstract void updateUITitle();
}

