/*
 * Decompiled with CFR 0.152.
 */
package net.atomique.ksar;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JOptionPane;
import net.atomique.ksar.GlobalOptions;
import net.atomique.ksar.kSar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalCommand
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(LocalCommand.class);
    private kSar mysar = null;
    private InputStream in = null;
    private String command = null;
    private BufferedReader myfilereader = null;
    private Process p = null;

    public LocalCommand(kSar hissar) {
        this.mysar = hissar;
        try {
            this.command = JOptionPane.showInputDialog(GlobalOptions.getUI(), "Enter local command ", "sar -A");
            if (this.command == null) {
                return;
            }
            String[] cmdArray = this.command.split(" +");
            ArrayList<String> cmdList = new ArrayList<String>();
            cmdList.addAll(Arrays.asList(cmdArray));
            ProcessBuilder pb = new ProcessBuilder(cmdList);
            pb.environment().put("LC_ALL", "C");
            this.p = pb.start();
            this.in = this.p.getInputStream();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(GlobalOptions.getUI(), "There was a problem while running the command ", "Local error", 0);
            this.in = null;
        }
    }

    public LocalCommand(kSar hissar, String hiscommand) {
        this.mysar = hissar;
        this.command = hiscommand;
        try {
            String[] envvar = new String[]{"LC_ALL=C"};
            this.p = Runtime.getRuntime().exec(this.command, envvar);
            this.in = this.p.getInputStream();
        }
        catch (Exception e) {
            if (GlobalOptions.hasUI()) {
                JOptionPane.showMessageDialog(GlobalOptions.getUI(), "There was a problem while running the command " + this.command, "Local error", 0);
            } else {
                log.error("There was a problem while running the command {}", (Object)this.command);
            }
            this.in = null;
        }
    }

    private void close() {
        if (this.p != null) {
            this.p.destroy();
        }
        try {
            if (this.myfilereader != null) {
                this.myfilereader.close();
            }
        }
        catch (IOException ex) {
            log.error("IO Exception", ex);
        }
    }

    @Override
    public void run() {
        if (this.in == null) {
            return;
        }
        this.myfilereader = new BufferedReader(new InputStreamReader(this.in));
        if (this.myfilereader == null) {
            return;
        }
        this.mysar.parse(this.myfilereader);
        this.close();
    }

    public String get_action() {
        if (this.command != null) {
            return "cmd://" + this.command;
        }
        return null;
    }
}

