/*
 * Decompiled with CFR 0.152.
 */
package net.atomique.ksar;

import java.util.ResourceBundle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import net.atomique.ksar.Config;
import net.atomique.ksar.GlobalOptions;
import net.atomique.ksar.VersionNumber;
import net.atomique.ksar.ui.Desktop;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger log = LoggerFactory.getLogger(Main.class);
    static Config config = null;
    static GlobalOptions globaloptions = null;
    static ResourceBundle resource = ResourceBundle.getBundle("net/atomique/ksar/Language/Message");

    public static void usage() {
        Main.show_version();
    }

    public static void show_version() {
        log.info("ksar Version : {}", (Object)VersionNumber.getVersionString());
    }

    private static void set_lookandfeel() {
        for (UIManager.LookAndFeelInfo laf : UIManager.getInstalledLookAndFeels()) {
            if (!Config.getLandf().equals(laf.getName())) continue;
            try {
                UIManager.setLookAndFeel(laf.getClassName());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
                log.error("lookandfeel Exception", ex);
            }
        }
    }

    public static void make_ui() {
        log.trace("MainScreen");
        Main.set_lookandfeel();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GlobalOptions.setUI(new Desktop());
                SwingUtilities.updateComponentTreeUI(GlobalOptions.getUI());
                GlobalOptions.getUI().add_window();
                GlobalOptions.getUI().maxall();
            }
        });
    }

    public static void main(String[] args) {
        int i = 0;
        log.info("ksar Version : {}", (Object)VersionNumber.getVersionString());
        log.info("Java runtime Version : {}", (Object)System.getProperty("java.runtime.version"));
        log.info("Java runtime architecture : {}", (Object)System.getProperty("os.arch"));
        String mrjVersion = System.getProperty("mrj.version");
        if (mrjVersion != null) {
            System.setProperty("com.apple.mrj.application.growbox.intrudes", "false");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "kSar");
            System.setProperty("apple.laf.useScreenMenuBar", "true");
        }
        config = Config.getInstance();
        globaloptions = GlobalOptions.getInstance();
        if (args.length > 0) {
            while (i < args.length && args[i].startsWith("-")) {
                String arg;
                if ("-version".equals(arg = args[i++])) {
                    Main.show_version();
                    System.exit(0);
                }
                if ("-help".equals(arg)) {
                    Main.usage();
                    continue;
                }
                if ("-test".equals(arg)) {
                    GlobalOptions.setDodebug(true);
                    continue;
                }
                if (!"-input".equals(arg)) continue;
                if (i < args.length) {
                    GlobalOptions.setCLfilename(args[i++]);
                    continue;
                }
                Main.exit_error(resource.getString("INPUT_REQUIRE_ARG"));
            }
        }
        Main.make_ui();
    }

    public static void exit_error(String message) {
        log.error(message);
        System.exit(1);
    }
}

