/*
 * Decompiled with CFR 0.152.
 */
package net.atomique.ksar;

import java.time.DateTimeException;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.HashMap;
import java.util.Map;
import net.atomique.ksar.AllParser;
import net.atomique.ksar.GlobalOptions;
import net.atomique.ksar.kSar;
import net.atomique.ksar.xml.OSConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OSParser
extends AllParser {
    private static final Logger log = LoggerFactory.getLogger(OSParser.class);
    protected Map<String, Object> ListofGraph = new HashMap<String, Object>();
    protected String lastStat = null;
    protected Object currentStatObj = null;
    protected String ostype = null;
    protected String Hostname = null;
    protected String OSversion = null;
    protected String Kernel = null;
    protected String CpuType = null;
    protected String MacAddress = null;
    protected String Memory = null;
    protected String NBDisk = null;
    protected String NBCpu = null;
    protected String ENT = null;

    public OSParser() {
    }

    @Override
    public void init(kSar hissar, String header) {
        String[] s = header.split("\\s+");
        this.mysar = hissar;
        this.ParserName = s[0];
        this.myosconfig = GlobalOptions.getOSinfo(s[0]);
        this.parse_header(header);
    }

    public OSParser(kSar hissar, String header) {
        this.init(hissar, header);
    }

    public OSConfig get_OSConfig() {
        return this.myosconfig;
    }

    public void setHostname(String s) {
        this.Hostname = s;
    }

    public void setOSversion(String s) {
        this.OSversion = s;
    }

    public void setKernel(String s) {
        this.Kernel = s;
    }

    public void setCpuType(String s) {
        this.CpuType = s;
    }

    public void setMacAddress(String s) {
        this.MacAddress = s;
    }

    public void setMemory(String s) {
        this.Memory = s;
    }

    public void setNBDisk(String s) {
        this.NBDisk = s;
    }

    public void setNBCpu(String s) {
        this.NBCpu = s;
    }

    public void setENT(String s) {
        this.ENT = s;
    }

    @Override
    public String getInfo() {
        StringBuilder tmpstr = new StringBuilder();
        tmpstr.append("OS Type: ").append(this.ostype);
        if (this.OSversion != null) {
            tmpstr.append("OS Version: ").append(this.OSversion).append("\n");
        }
        if (this.Kernel != null) {
            tmpstr.append("Kernel Release: ").append(this.Kernel).append("\n");
        }
        if (this.CpuType != null) {
            tmpstr.append("CPU Type: ").append(this.CpuType).append("\n");
        }
        if (this.Hostname != null) {
            tmpstr.append("Hostname: ").append(this.Hostname).append("\n");
        }
        if (this.MacAddress != null) {
            tmpstr.append("Mac Address: ").append(this.MacAddress).append("\n");
        }
        if (this.Memory != null) {
            tmpstr.append("Memory: ").append(this.Memory).append("\n");
        }
        if (this.NBDisk != null) {
            tmpstr.append("Number of disks: ").append(this.NBDisk).append("\n");
        }
        if (this.NBCpu != null) {
            tmpstr.append("Number of CPU: ").append(this.NBCpu).append("\n");
        }
        if (this.ENT != null) {
            tmpstr.append("Ent: ").append(this.ENT).append("\n");
        }
        if (this.sarStartDate != null) {
            tmpstr.append("Start of SAR: ").append(this.sarStartDate).append("\n");
        }
        if (this.sarEndDate != null) {
            tmpstr.append("End of SAR: ").append(this.sarEndDate).append("\n");
        }
        tmpstr.append("\n");
        return tmpstr.toString();
    }

    public String gethostName() {
        return this.Hostname;
    }

    public String getOstype() {
        return this.ostype;
    }

    public void setOstype(String ostype) {
        this.ostype = ostype;
    }

    @Override
    public final void updateUITitle() {
        if (this.mysar.getDataView() != null) {
            String asFormattedDateTimeStart = null;
            String asFormattedDateTimeEnd = null;
            try {
                DateTimeFormatter formatter = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT);
                if (this.getStartOfGraph() != null) {
                    asFormattedDateTimeStart = this.getStartOfGraph().format(formatter);
                }
                if (this.getEndOfGraph() != null) {
                    asFormattedDateTimeEnd = this.getEndOfGraph().format(formatter);
                }
            }
            catch (DateTimeException ex) {
                log.error("unable to format time", ex);
            }
            if (asFormattedDateTimeStart != null && asFormattedDateTimeEnd != null) {
                this.mysar.getDataView().setTitle(String.format("%s from %s to %s", this.Hostname, asFormattedDateTimeStart, asFormattedDateTimeEnd));
            }
        }
    }
}

