/*
 * Decompiled with CFR 0.152.
 */
package net.atomique.ksar.export;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import javax.swing.JDialog;
import javax.swing.JProgressBar;
import net.atomique.ksar.graph.Graph;
import net.atomique.ksar.graph.List;
import net.atomique.ksar.kSar;
import net.atomique.ksar.ui.ParentNodeInfo;
import net.atomique.ksar.ui.SortedTreeNode;
import net.atomique.ksar.ui.TreeNodeInfo;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Second;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileCSV
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(FileCSV.class);
    private StringBuilder tmpcsv = new StringBuilder();
    private int progress_info = 0;
    private String csvfilename;
    private kSar mysar;
    private JProgressBar progress_bar = null;
    private JDialog dialog = null;

    public FileCSV(String filename, kSar hissar) {
        this.csvfilename = filename;
        this.mysar = hissar;
    }

    public FileCSV(String filename, kSar hissar, JProgressBar g, JDialog d) {
        this(filename, hissar);
        this.progress_bar = g;
        this.dialog = d;
    }

    @Override
    public void run() {
        BufferedWriter out;
        try {
            out = new BufferedWriter(new FileWriter(this.csvfilename));
        }
        catch (IOException ex) {
            log.error("IO Exception", ex);
            out = null;
        }
        this.tmpcsv.append("Date;");
        this.export_treenode_header(this.mysar.graphtree);
        this.tmpcsv.append("\n");
        for (LocalDateTime tmpLDT : this.mysar.myparser.getDateSamples()) {
            Second tmp = new Second(tmpLDT.getSecond(), tmpLDT.getMinute(), tmpLDT.getHour(), tmpLDT.getDayOfMonth(), tmpLDT.getMonthValue(), tmpLDT.getYear());
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd/MM/yy HH:mm:ss");
            String text = tmpLDT.format(formatter);
            this.tmpcsv.append(text).append(";");
            this.export_treenode_data(this.mysar.graphtree, tmp);
            this.tmpcsv.append("\n");
        }
        try {
            out.write(this.tmpcsv.toString());
            out.close();
        }
        catch (IOException ex) {
            log.error("IO Exception", ex);
        }
        if (this.dialog != null) {
            this.dialog.dispose();
        }
    }

    private void export_treenode_header(SortedTreeNode node) {
        int num = node.getChildCount();
        if (num > 0) {
            Object obj1 = node.getUserObject();
            if (obj1 instanceof ParentNodeInfo) {
                ParentNodeInfo tmpnode = (ParentNodeInfo)obj1;
                List list = tmpnode.getNode_object();
            }
            for (int i = 0; i < num; ++i) {
                SortedTreeNode l = (SortedTreeNode)node.getChildAt(i);
                this.export_treenode_header(l);
            }
        } else {
            TreeNodeInfo tmpnode;
            Graph nodeobj;
            Object obj1 = node.getUserObject();
            if (obj1 instanceof TreeNodeInfo && (nodeobj = (tmpnode = (TreeNodeInfo)obj1).getNode_object()).doPrint()) {
                this.tmpcsv.append(nodeobj.getCsvHeader());
            }
        }
    }

    private void export_treenode_data(SortedTreeNode node, RegularTimePeriod time) {
        int num = node.getChildCount();
        if (num > 0) {
            Object obj1 = node.getUserObject();
            if (obj1 instanceof ParentNodeInfo) {
                ParentNodeInfo tmpnode = (ParentNodeInfo)obj1;
                List list = tmpnode.getNode_object();
            }
            for (int i = 0; i < num; ++i) {
                SortedTreeNode l = (SortedTreeNode)node.getChildAt(i);
                this.export_treenode_data(l, time);
            }
        } else {
            TreeNodeInfo tmpnode;
            Graph nodeobj;
            Object obj1 = node.getUserObject();
            if (obj1 instanceof TreeNodeInfo && (nodeobj = (tmpnode = (TreeNodeInfo)obj1).getNode_object()).doPrint()) {
                this.tmpcsv.append(nodeobj.getCsvLine(time));
                this.update_ui();
            }
        }
    }

    private void update_ui() {
        if (this.progress_bar != null) {
            this.progress_bar.setValue(++this.progress_info);
            this.progress_bar.repaint();
        }
    }
}

