/*
 * Decompiled with CFR 0.152.
 */
package net.atomique.ksar.export;

import com.itextpdf.awt.PdfGraphics2D;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.ExceptionConverter;
import com.itextpdf.text.FontFactory;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfDestination;
import com.itextpdf.text.pdf.PdfOutline;
import com.itextpdf.text.pdf.PdfPageEventHelper;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import java.awt.Graphics;
import java.awt.geom.Rectangle2D;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JDialog;
import javax.swing.JProgressBar;
import net.atomique.ksar.Config;
import net.atomique.ksar.VersionNumber;
import net.atomique.ksar.graph.Graph;
import net.atomique.ksar.graph.List;
import net.atomique.ksar.kSar;
import net.atomique.ksar.ui.ParentNodeInfo;
import net.atomique.ksar.ui.SortedTreeNode;
import net.atomique.ksar.ui.TreeNodeInfo;
import org.jfree.chart.JFreeChart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilePDF
extends PdfPageEventHelper
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(FilePDF.class);
    private int progress_info = 0;
    private float pdfwidth;
    private float pdfheight;
    private int pdfmargins = 10;
    private float pageheight;
    private float pagewidth;
    private int total_pages = 1;
    private String pdffilename;
    private Document document = null;
    private PdfWriter writer = null;
    private PdfContentByte pdfcb;
    private kSar mysar;
    private BaseFont bf = FontFactory.getFont("Courier").getCalculatedBaseFont(false);
    private JProgressBar progress_bar = null;
    private JDialog dialog = null;

    private FilePDF(String filename, kSar hissar) {
        this.pdffilename = filename;
        this.mysar = hissar;
    }

    public FilePDF(String filename, kSar hissar, JProgressBar g, JDialog d) {
        this(filename, hissar);
        this.progress_bar = g;
        this.dialog = d;
    }

    @Override
    public void run() {
        this.total_pages += this.mysar.get_page_to_print();
        switch (Config.getPDFPageFormat()) {
            case "A4": {
                this.document = new Document(PageSize.A4.rotate());
                break;
            }
            case "LEGAL": {
                this.document = new Document(PageSize.LEGAL.rotate());
                break;
            }
            case "LETTER": {
                this.document = new Document(PageSize.LETTER.rotate());
                break;
            }
            default: {
                this.document = new Document(PageSize.A4.rotate());
            }
        }
        this.pdfheight = this.document.getPageSize().getHeight();
        this.pdfwidth = this.document.getPageSize().getWidth();
        this.pageheight = this.pdfheight - (float)(2 * this.pdfmargins);
        this.pagewidth = this.pdfwidth - (float)(2 * this.pdfmargins);
        try {
            this.writer = PdfWriter.getInstance(this.document, new FileOutputStream(this.pdffilename));
        }
        catch (DocumentException | FileNotFoundException ex) {
            log.error("Parser Exception", ex);
        }
        this.writer.setPageEvent(this);
        this.writer.setCompressionLevel(0);
        this.document.addTitle("kSar Grapher");
        this.document.addCreator("kSar Version:" + VersionNumber.getVersionString());
        this.document.addAuthor("https://github.com/vlsi/ksar");
        this.document.open();
        this.pdfcb = this.writer.getDirectContent();
        PdfOutline root = this.pdfcb.getRootOutline();
        this.IndexPage(this.document);
        this.export_treenode(this.mysar.graphtree, root);
        this.document.close();
        if (this.dialog != null) {
            this.dialog.dispose();
        }
    }

    private void export_treenode(SortedTreeNode node, PdfOutline root) {
        int num = node.getChildCount();
        if (num > 0) {
            ParentNodeInfo tmpnode;
            List nodeobj;
            Object obj1 = node.getUserObject();
            if (obj1 instanceof ParentNodeInfo && (nodeobj = (tmpnode = (ParentNodeInfo)obj1).getNode_object()).isPrintSelected()) {
                root = new PdfOutline(root, new PdfDestination(1), nodeobj.getTitle());
            }
            for (int i = 0; i < num; ++i) {
                SortedTreeNode l = (SortedTreeNode)node.getChildAt(i);
                this.export_treenode(l, root);
            }
        } else {
            TreeNodeInfo tmpnode;
            Graph nodeobj;
            Object obj1 = node.getUserObject();
            if (obj1 instanceof TreeNodeInfo && (nodeobj = (tmpnode = (TreeNodeInfo)obj1).getNode_object()).isPrintSelected()) {
                new PdfOutline(root, new PdfDestination(1), nodeobj.getTitle());
                this.update_ui();
                this.addchart(this.writer, nodeobj);
                this.document.newPage();
            }
        }
    }

    private void update_ui() {
        if (this.progress_bar != null) {
            this.progress_bar.setValue(++this.progress_info);
            this.progress_bar.repaint();
        }
    }

    @Override
    public void onEndPage(PdfWriter writer, Document document) {
        try {
            int pageNumber = writer.getPageNumber();
            String text = "Page " + pageNumber + "/" + this.total_pages;
            String hostName = this.mysar.myparser.gethostName();
            String date = this.mysar.myparser.getDate();
            this.pdfcb.beginText();
            this.pdfcb.setFontAndSize(this.bf, 10.0f);
            this.pdfcb.setColorFill(new BaseColor(0, 0, 0));
            if (pageNumber > 1) {
                this.pdfcb.showTextAligned(0, hostName, this.pdfmargins, this.pdfheight - (float)this.pdfmargins, 0.0f);
                this.pdfcb.showTextAligned(2, date, this.pdfwidth - (float)this.pdfmargins, this.pdfheight - (float)this.pdfmargins, 0.0f);
            }
            this.pdfcb.showTextAligned(2, text, this.pdfwidth - (float)this.pdfmargins, this.pdfmargins - 5, 0.0f);
            this.pdfcb.endText();
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    private void addchart(PdfWriter writer, Graph graph) {
        JFreeChart chart = graph.getgraph(this.mysar.myparser.getStartOfGraph(), this.mysar.myparser.getEndOfGraph());
        PdfTemplate pdftpl = this.pdfcb.createTemplate(this.pagewidth, this.pageheight);
        PdfGraphics2D g2d = new PdfGraphics2D(pdftpl, this.pagewidth, this.pageheight);
        Rectangle2D.Double r2d = new Rectangle2D.Double(0.0, 0.0, this.pagewidth, this.pageheight);
        chart.draw(g2d, r2d);
        ((Graphics)g2d).dispose();
        this.pdfcb.addTemplate(pdftpl, this.pdfmargins, this.pdfmargins);
        try {
            writer.releaseTemplate(pdftpl);
        }
        catch (IOException ioe) {
            log.error("Unable to write to : {}", (Object)this.pdffilename);
        }
    }

    private void IndexPage(Document document) {
        try {
            float pdfCenter = (this.pdfwidth - (float)this.pdfmargins) / 2.0f;
            String title = "SAR Statistics";
            String t_date = "on " + this.mysar.myparser.getDate();
            String hostName = "for " + this.mysar.myparser.gethostName();
            String osType = this.mysar.myparser.getOstype();
            String graphStart = this.mysar.myparser.getStartOfGraph().toString();
            String graphEnd = this.mysar.myparser.getEndOfGraph().toString();
            this.pdfcb.beginText();
            this.pdfcb.setFontAndSize(this.bf, 40.0f);
            this.pdfcb.setColorFill(new BaseColor(0, 0, 0));
            this.pdfcb.showTextAligned(1, title, pdfCenter, 500.0f, 0.0f);
            this.pdfcb.setFontAndSize(this.bf, 32.0f);
            this.pdfcb.showTextAligned(1, hostName + " (" + osType + ")", pdfCenter, 400.0f, 0.0f);
            this.pdfcb.showTextAligned(1, t_date, pdfCenter, 300.0f, 0.0f);
            this.pdfcb.setFontAndSize(this.bf, 20.0f);
            this.pdfcb.showTextAligned(1, graphStart, pdfCenter, 200.0f, 0.0f);
            this.pdfcb.showTextAligned(1, graphEnd, pdfCenter, 150.0f, 0.0f);
            this.pdfcb.endText();
            document.newPage();
        }
        catch (Exception de) {
            log.error("IndexPage Exception", de);
        }
    }
}

