/*
 * Decompiled with CFR 0.152.
 */
package net.atomique.ksar.graph;

import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;

public class IEEE1541Number
extends NumberFormat {
    private static final double IEC_kibi = 1024.0;
    private static final double IEC_mebi = 1048576.0;
    private static final double IEC_gibi = 1.073741824E9;
    private int kilo = 0;

    public IEEE1541Number(int value) {
        this.kilo = value;
    }

    @Override
    public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
        DecimalFormat formatter = new DecimalFormat("#,##0.0");
        if (this.kilo == 0) {
            return toAppendTo.append(formatter.format(number));
        }
        if (number * (double)this.kilo < 1024.0) {
            return toAppendTo.append(formatter.format(number));
        }
        if (number * (double)this.kilo < 1048576.0) {
            toAppendTo.append(formatter.format(number * (double)this.kilo / 1024.0)).append(" Ki");
            return toAppendTo;
        }
        if (number * (double)this.kilo < 1.073741824E9) {
            toAppendTo.append(formatter.format(number * (double)this.kilo / 1048576.0)).append(" Mi");
            return toAppendTo;
        }
        toAppendTo.append(formatter.format(number * (double)this.kilo / 1.073741824E9)).append(" Gi");
        return toAppendTo;
    }

    @Override
    public StringBuffer format(long number, StringBuffer toAppendTo, FieldPosition pos) {
        return this.format((double)(number * (long)this.kilo), toAppendTo, pos);
    }

    @Override
    public Number parse(String source, ParsePosition parsePosition) {
        return null;
    }
}

