/*
 * Decompiled with CFR 0.152.
 */
package net.atomique.ksar;

import java.beans.PropertyVetoException;
import java.io.BufferedReader;
import java.io.IOException;
import javax.swing.JDesktopPane;
import net.atomique.ksar.FileRead;
import net.atomique.ksar.GlobalOptions;
import net.atomique.ksar.LocalCommand;
import net.atomique.ksar.OSParser;
import net.atomique.ksar.SSHCommand;
import net.atomique.ksar.graph.Graph;
import net.atomique.ksar.ui.DataView;
import net.atomique.ksar.ui.SortedTreeNode;
import net.atomique.ksar.ui.TreeNodeInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class kSar {
    private static final Logger log = LoggerFactory.getLogger(kSar.class);
    DataView dataview = null;
    private long lines_parsed = 0L;
    private String reload_action = "Empty";
    private Thread launched_action = null;
    private boolean action_interrupted = false;
    public OSParser myparser = null;
    private boolean Parsing = false;
    public int total_graph = 0;
    public SortedTreeNode graphtree = new SortedTreeNode("kSar");
    public int page_to_print = 0;

    public kSar(JDesktopPane DesktopPane) {
        this.dataview = new DataView(this);
        this.dataview.toFront();
        this.dataview.setVisible(true);
        this.dataview.setTitle("Empty");
        DesktopPane.add(this.dataview);
        try {
            int num = DesktopPane.getAllFrames().length;
            if (num != 1) {
                this.dataview.reshape(5 * num, 5 * num, 800, 600);
            } else {
                this.dataview.reshape(0, 0, 800, 600);
            }
            this.dataview.setSelected(true);
        }
        catch (PropertyVetoException vetoe) {
            log.error("PropertyVetoException", vetoe);
        }
        if (GlobalOptions.getCLfilename() != null) {
            this.do_fileread(GlobalOptions.getCLfilename());
        }
    }

    public kSar() {
    }

    public void do_fileread(String filename) {
        this.launched_action = filename == null ? new FileRead(this) : new FileRead(this, filename);
        this.reload_action = ((FileRead)this.launched_action).get_action();
        this.do_action();
    }

    public void do_localcommand(String cmd) {
        this.launched_action = cmd == null ? new LocalCommand(this) : new LocalCommand(this, cmd);
        this.reload_action = ((LocalCommand)this.launched_action).get_action();
        this.do_action();
    }

    public void do_sshread(String cmd) {
        this.launched_action = cmd == null ? new SSHCommand(this) : new SSHCommand(this, cmd);
        this.reload_action = ((SSHCommand)this.launched_action).get_action();
        this.do_action();
    }

    private void do_action() {
        if (this.reload_action == null) {
            log.info("action is null");
            return;
        }
        if (this.launched_action != null) {
            if (this.dataview != null) {
                this.dataview.notifyrun(true);
            }
            this.launched_action.start();
        }
    }

    public int parse(BufferedReader br) {
        String current_line = null;
        long parsing_start = 0L;
        long parsing_end = 0L;
        int parser_return = 0;
        parsing_start = System.currentTimeMillis();
        try {
            while ((current_line = br.readLine()) != null && !this.action_interrupted) {
                String[] columns;
                this.Parsing = true;
                ++this.lines_parsed;
                if (current_line.length() == 0 || (columns = current_line.split("\\s+")).length == 0) continue;
                String ParserType = columns[0];
                try {
                    Class classtmp = GlobalOptions.getParser(ParserType);
                    if (classtmp != null) {
                        if (this.myparser == null) {
                            this.myparser = (OSParser)classtmp.newInstance();
                            this.myparser.init(this, current_line);
                            continue;
                        }
                        if (this.myparser.getParserName().equals(columns[0])) {
                            this.myparser.parse_header(current_line);
                            continue;
                        }
                    }
                }
                catch (IllegalAccessException | InstantiationException ex) {
                    log.error("Parser Exception", ex);
                }
                if (this.myparser == null) {
                    log.error("unknown parser");
                    this.Parsing = false;
                    return -1;
                }
                parser_return = this.myparser.parse(current_line, columns);
                if (parser_return == 1 && GlobalOptions.isDodebug()) {
                    log.trace("### {}", (Object)current_line);
                }
                if (parser_return < 0 && GlobalOptions.isDodebug()) {
                    log.trace("ERR {}", (Object)current_line);
                }
                this.myparser.updateUITitle();
            }
        }
        catch (IOException ex) {
            log.error("IO Exception", ex);
            this.Parsing = false;
        }
        if (this.dataview != null) {
            this.dataview.treehome();
            this.dataview.notifyrun(false);
            this.dataview.setHasData(true);
        }
        parsing_end = System.currentTimeMillis();
        if (GlobalOptions.isDodebug()) {
            log.trace("time to parse: {} ms", (Object)(parsing_end - parsing_start));
            if (this.myparser != null) {
                log.trace("number of datesamples: {}", (Object)this.myparser.DateSamples.size());
            }
        }
        this.Parsing = false;
        return -1;
    }

    public void cleared() {
        this.aborted();
    }

    public void aborted() {
        if (this.dataview != null) {
            log.trace("reset menu");
            this.dataview.notifyrun(false);
        }
    }

    public boolean isAction_interrupted() {
        return this.action_interrupted;
    }

    public void interrupt_parsing() {
        if (this.isParsing()) {
            this.action_interrupted = true;
        }
    }

    public void add2tree(SortedTreeNode parent, SortedTreeNode newNode) {
        if (this.dataview != null) {
            this.dataview.add2tree(parent, newNode);
        }
    }

    public int get_page_to_print() {
        this.page_to_print = 0;
        this.count_printSelected(this.graphtree);
        return this.page_to_print;
    }

    public void count_printSelected(SortedTreeNode node) {
        int num = node.getChildCount();
        if (num > 0) {
            Object obj1 = node.getUserObject();
            for (int i = 0; i < num; ++i) {
                SortedTreeNode l = (SortedTreeNode)node.getChildAt(i);
                this.count_printSelected(l);
            }
        } else {
            TreeNodeInfo tmpnode;
            Graph nodeobj;
            Object obj1 = node.getUserObject();
            if (obj1 instanceof TreeNodeInfo && (nodeobj = (tmpnode = (TreeNodeInfo)obj1).getNode_object()).isPrintSelected()) {
                ++this.page_to_print;
            }
        }
    }

    public DataView getDataView() {
        return this.dataview;
    }

    public boolean isParsing() {
        return this.Parsing;
    }
}

