/*
 * Decompiled with CFR 0.152.
 */
package net.atomique.ksar.parser;

import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import net.atomique.ksar.GlobalOptions;
import net.atomique.ksar.OSParser;
import net.atomique.ksar.graph.Graph;
import net.atomique.ksar.graph.List;
import net.atomique.ksar.xml.GraphConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AIX
extends OSParser {
    private static final Logger log = LoggerFactory.getLogger(AIX.class);
    boolean under_average = false;

    @Override
    public void parse_header(String s) {
        String[] columns = s.split("\\s+");
        this.setOstype(columns[0]);
        this.setHostname(columns[1]);
        this.setOSversion(columns[2] + "." + columns[3]);
        this.setMacAddress(columns[4]);
        this.setDate(columns[5]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int parse(String line, String[] columns) {
        Object ag;
        if ("Average".equals(columns[0])) {
            this.under_average = true;
            return 0;
        }
        if (line.indexOf("unix restarts") >= 0 || line.indexOf(" unix restarted") >= 0) {
            return 0;
        }
        if (line.indexOf("System Configuration") >= 0 || line.indexOf("System configuration") >= 0) {
            return 0;
        }
        if (line.indexOf("State change") >= 0) {
            return 0;
        }
        try {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(this.timeFormat);
            this.parsetime = LocalTime.parse(columns[0], formatter);
            LocalDateTime localDateTime = LocalDateTime.of(this.parsedate, this.parsetime);
            this.setStartAndEndOfGraph(localDateTime);
            this.firstdatacolumn = 1;
        }
        catch (DateTimeParseException ex) {
            if (!"DEVICE".equals(this.currentStat) || "CPUS".equals(this.currentStat)) {
                log.error("unable to parse time {}", (Object)columns[0], (Object)ex);
                return -1;
            }
            this.firstdatacolumn = 0;
        }
        String checkStat = this.myosconfig.getStat(columns, this.firstdatacolumn);
        if (checkStat != null) {
            Object v = this.ListofGraph.get(checkStat);
            if (v != null) {
                this.currentStat = checkStat;
                return 0;
            }
            GraphConfig mygraphinfo = this.myosconfig.getGraphConfig(checkStat);
            if (mygraphinfo == null) {
                this.currentStat = checkStat;
                return 0;
            }
            if ("unique".equals(mygraphinfo.getType())) {
                Graph graph = new Graph(this.mysar, mygraphinfo, mygraphinfo.getTitle(), line, this.firstdatacolumn, this.mysar.graphtree);
                this.ListofGraph.put(checkStat, graph);
                this.currentStat = checkStat;
                return 0;
            }
            if ("multiple".equals(mygraphinfo.getType())) {
                List list = new List(this.mysar, mygraphinfo, mygraphinfo.getTitle(), line, this.firstdatacolumn);
                this.ListofGraph.put(checkStat, list);
                this.currentStat = checkStat;
                return 0;
            }
        }
        if (this.lastStat != null) {
            if (!this.lastStat.equals(this.currentStat)) {
                if (GlobalOptions.isDodebug()) {
                    log.debug("Stat change from {} to {}", (Object)this.lastStat, (Object)this.currentStat);
                }
                this.lastStat = this.currentStat;
                this.under_average = false;
            }
        } else {
            this.lastStat = this.currentStat;
        }
        if ("IGNORE".equals(this.currentStat)) {
            return 1;
        }
        if ("NONE".equals(this.currentStat)) {
            return -1;
        }
        if (this.under_average) {
            return 0;
        }
        this.currentStatObj = this.ListofGraph.get(this.currentStat);
        if (this.currentStatObj == null) {
            return -1;
        }
        LocalDateTime localDateTime = LocalDateTime.of(this.parsedate, this.parsetime);
        this.DateSamples.add(localDateTime);
        if (this.currentStatObj instanceof Graph) {
            ag = (Graph)this.currentStatObj;
            return ((Graph)ag).parse_line(localDateTime, line);
        }
        if (this.currentStatObj instanceof List) {
            ag = (List)this.currentStatObj;
            return ((List)ag).parse_line(localDateTime, line);
        }
        return -1;
    }
}

