/*
 * Decompiled with CFR 0.152.
 */
package net.atomique.ksar.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import net.atomique.ksar.Config;
import net.atomique.ksar.GlobalOptions;
import net.atomique.ksar.export.FileCSV;
import net.atomique.ksar.export.FilePDF;
import net.atomique.ksar.graph.Graph;
import net.atomique.ksar.graph.List;
import net.atomique.ksar.kSar;
import net.atomique.ksar.ui.GraphSelection;
import net.atomique.ksar.ui.GraphView;
import net.atomique.ksar.ui.ParentNodeInfo;
import net.atomique.ksar.ui.SortedTreeNode;
import net.atomique.ksar.ui.TreeNodeInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataView
extends JInternalFrame {
    private static final Logger log = LoggerFactory.getLogger(DataView.class);
    private JMenuItem CSVMenu;
    private JMenu GraphMenu;
    private JMenuItem LoadCommand;
    private JMenuItem LoadFile;
    private JMenuItem LoadSSH;
    private JMenuItem PDFMenu;
    private JMenuItem addgraphMenu;
    private JMenu dataMenu;
    private JPanel displayPanel;
    private JMenu exportMenu;
    private JButton jButton1;
    private JMenuBar jMenuBar1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JSplitPane jSplitPane1;
    private JTree jTree1;
    private boolean has_fresh_data = false;
    private kSar mysar = null;
    private JPanel current_panel = null;
    private GraphView mygraphview = new GraphView();
    private JPanel askparentPanel = null;
    private int total_graph = 0;

    public DataView(kSar sar) {
        this.initComponents();
        this.mysar = sar;
        this.jTree1.setModel(new DefaultTreeModel(this.mysar.graphtree));
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jSplitPane1 = new JSplitPane();
        this.jPanel2 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTree1 = new JTree();
        this.jButton1 = new JButton();
        this.displayPanel = new JPanel();
        this.jMenuBar1 = new JMenuBar();
        this.dataMenu = new JMenu();
        this.LoadFile = new JMenuItem();
        this.LoadCommand = new JMenuItem();
        this.LoadSSH = new JMenuItem();
        this.GraphMenu = new JMenu();
        this.addgraphMenu = new JMenuItem();
        this.exportMenu = new JMenu();
        this.PDFMenu = new JMenuItem();
        this.CSVMenu = new JMenuItem();
        this.setClosable(true);
        this.setDefaultCloseOperation(0);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        try {
            this.setSelected(true);
        }
        catch (PropertyVetoException e1) {
            e1.printStackTrace();
        }
        this.setVisible(true);
        this.addInternalFrameListener(new InternalFrameListener(){

            @Override
            public void internalFrameOpened(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameClosing(InternalFrameEvent evt) {
                DataView.this.formInternalFrameClosing(evt);
            }

            @Override
            public void internalFrameClosed(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameIconified(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameDeiconified(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameActivated(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameDeactivated(InternalFrameEvent evt) {
            }
        });
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel2.setMinimumSize(new Dimension(150, 46));
        this.jPanel2.setLayout(new BorderLayout());
        this.jTree1.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                DataView.this.jTree1ValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTree1);
        this.jPanel2.add((Component)this.jScrollPane1, "Center");
        this.jButton1.setEnabled(false);
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataView.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel2.add((Component)this.jButton1, "South");
        this.jSplitPane1.setLeftComponent(this.jPanel2);
        this.displayPanel.setLayout(new BorderLayout());
        this.jSplitPane1.setRightComponent(this.displayPanel);
        this.jPanel1.add((Component)this.jSplitPane1, "Center");
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.dataMenu.setText("Data");
        this.LoadFile.setText("Load from a file...");
        this.LoadFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataView.this.LoadFileActionPerformed(evt);
            }
        });
        this.dataMenu.add(this.LoadFile);
        this.LoadCommand.setText("Load from a local Command...");
        this.LoadCommand.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataView.this.LoadCommandActionPerformed(evt);
            }
        });
        this.dataMenu.add(this.LoadCommand);
        this.LoadSSH.setText("Load from a SSH Command...");
        this.LoadSSH.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataView.this.LoadSSHActionPerformed(evt);
            }
        });
        this.dataMenu.add(this.LoadSSH);
        this.jMenuBar1.add(this.dataMenu);
        this.GraphMenu.setText("Graph");
        this.GraphMenu.setEnabled(false);
        this.addgraphMenu.setText("Add a Graph");
        this.addgraphMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataView.this.addgraphMenuActionPerformed(evt);
            }
        });
        this.GraphMenu.add(this.addgraphMenu);
        this.jMenuBar1.add(this.GraphMenu);
        this.exportMenu.setText("Export");
        this.exportMenu.setEnabled(false);
        this.PDFMenu.setText("Export to PDF...");
        this.PDFMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataView.this.PDFMenuActionPerformed(evt);
            }
        });
        this.exportMenu.add(this.PDFMenu);
        this.CSVMenu.setText("Export to CSV...");
        this.CSVMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataView.this.CSVMenuActionPerformed(evt);
            }
        });
        this.exportMenu.add(this.CSVMenu);
        this.jMenuBar1.add(this.exportMenu);
        this.setJMenuBar(this.jMenuBar1);
        this.pack();
    }

    private void formInternalFrameClosing(InternalFrameEvent evt) {
        this.save_data();
        this.dispose();
    }

    private void jTree1ValueChanged(TreeSelectionEvent evt) {
        TreePath treepath = evt.getPath();
        Object obj = treepath.getLastPathComponent();
        if (obj != null) {
            Object nodeobj;
            Object tmpnode;
            Object obj1;
            log.trace("mem: {}", (Object)Runtime.getRuntime().totalMemory());
            log.trace("free: {}", (Object)Runtime.getRuntime().freeMemory());
            SortedTreeNode treenode = (SortedTreeNode)obj;
            if (treenode.getRoot() == treenode) {
                if (this.current_panel != null) {
                    this.displayPanel.removeAll();
                    this.current_panel = null;
                }
                this.displayPanel.repaint();
            }
            if ((obj1 = treenode.getUserObject()) instanceof TreeNodeInfo) {
                tmpnode = (TreeNodeInfo)obj1;
                nodeobj = ((TreeNodeInfo)tmpnode).getNode_object();
                if (this.current_panel != null) {
                    this.displayPanel.removeAll();
                    this.current_panel = null;
                }
                this.mygraphview.setGraph((Graph)nodeobj);
                this.current_panel = this.mygraphview;
                this.displayPanel.add(this.mygraphview);
                this.displayPanel.validate();
                this.displayPanel.repaint();
            }
            if (obj1 instanceof ParentNodeInfo) {
                tmpnode = (ParentNodeInfo)obj1;
                nodeobj = ((ParentNodeInfo)tmpnode).getNode_object();
                if (this.current_panel != null) {
                    this.displayPanel.removeAll();
                    this.current_panel = null;
                }
                this.current_panel = ((List)nodeobj).run();
                this.displayPanel.add(this.current_panel);
                this.displayPanel.validate();
                this.displayPanel.repaint();
            }
        }
    }

    private void LoadCommandActionPerformed(ActionEvent evt) {
        this.mysar.do_localcommand(null);
    }

    private void LoadFileActionPerformed(ActionEvent evt) {
        this.mysar.do_fileread(null);
    }

    private void LoadSSHActionPerformed(ActionEvent evt) {
        this.mysar.do_sshread(null);
    }

    private void PDFMenuActionPerformed(ActionEvent evt) {
        GraphSelection tmp = new GraphSelection((Frame)GlobalOptions.getUI(), true, this);
        this.ask_treenode(this.mysar.graphtree, tmp);
        tmp.setVisible(true);
        if (!tmp.OkforExport) {
            tmp = null;
            return;
        }
        tmp = null;
        String filename = this.askSaveFilename("Export PDF", Config.getLastExportDirectory());
        if (filename == null) {
            return;
        }
        Config.setLastExportDirectory(filename);
        if (!Config.getLastExportDirectory().isDirectory()) {
            Config.setLastExportDirectory(Config.getLastExportDirectory().getParentFile());
            Config.save();
        }
        this.doExportPDF(filename);
    }

    private void CSVMenuActionPerformed(ActionEvent evt) {
        GraphSelection tmp = new GraphSelection((Frame)GlobalOptions.getUI(), true, this);
        this.ask_treenode(this.mysar.graphtree, tmp);
        tmp.setVisible(true);
        if (!tmp.OkforExport) {
            return;
        }
        String filename = this.askSaveFilename("Export CSV", Config.getLastExportDirectory());
        if (filename == null) {
            return;
        }
        Config.setLastExportDirectory(filename);
        if (!Config.getLastExportDirectory().isDirectory()) {
            Config.setLastExportDirectory(Config.getLastExportDirectory().getParentFile());
            Config.save();
        }
        this.doExportCSV(filename);
    }

    private void addgraphMenuActionPerformed(ActionEvent evt) {
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.mysar.interrupt_parsing();
        this.jButton1.setText("");
    }

    private String askSaveFilename(String title, File chdirto) {
        int returnVal;
        String filename = null;
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(title);
        if (chdirto != null) {
            chooser.setCurrentDirectory(chdirto);
        }
        if ((returnVal = chooser.showSaveDialog(GlobalOptions.getUI())) == 0) {
            filename = chooser.getSelectedFile().getAbsolutePath();
        }
        if (filename == null) {
            return null;
        }
        if (new File(filename).exists()) {
            Object[] choix = new String[]{"Yes", "No"};
            int resultat = JOptionPane.showOptionDialog(null, "Overwrite " + filename + " ?", "File Exist", 1, 3, null, choix, choix[1]);
            if (resultat != 0) {
                return null;
            }
        }
        return filename;
    }

    public void doExportPDF(String filename) {
        int pages = 0;
        pages = this.mysar.get_page_to_print();
        JPanel panel0 = new JPanel();
        JPanel panel1 = new JPanel();
        JPanel panel2 = new JPanel();
        JProgressBar pbar = new JProgressBar();
        pbar.setMinimum(0);
        pbar.setMaximum(pages);
        pbar.setStringPainted(true);
        JLabel mytitre = new JLabel("Exporting: ");
        panel1.add(mytitre);
        panel2.add(pbar);
        panel0.add(panel1);
        panel0.add(panel2);
        JDialog mydial = new JDialog();
        mydial.setDefaultCloseOperation(2);
        mydial.setContentPane(panel0);
        mydial.setSize(250, 80);
        mydial.pack();
        mydial.setLocationRelativeTo(GlobalOptions.getUI());
        mydial.setVisible(true);
        FilePDF t = new FilePDF(filename, this.mysar, pbar, mydial);
        Thread th = new Thread(t);
        th.start();
    }

    public void doExportCSV(String filename) {
        int pages = 0;
        pages = this.mysar.myparser.getDateSamples().size();
        JPanel panel0 = new JPanel();
        JPanel panel1 = new JPanel();
        JPanel panel2 = new JPanel();
        JProgressBar pbar = new JProgressBar();
        pbar.setMinimum(0);
        pbar.setMaximum(pages);
        pbar.setStringPainted(true);
        JLabel mytitre = new JLabel("Exporting: ");
        panel1.add(mytitre);
        panel2.add(pbar);
        panel0.add(panel1);
        panel0.add(panel2);
        JDialog mydial = new JDialog();
        mydial.setDefaultCloseOperation(2);
        mydial.setContentPane(panel0);
        mydial.setSize(250, 80);
        mydial.pack();
        mydial.setLocationRelativeTo(GlobalOptions.getUI());
        mydial.setVisible(true);
        FileCSV t = new FileCSV(filename, this.mysar, pbar, mydial);
        Thread th = new Thread(t);
        th.start();
    }

    public void ask_treenode(SortedTreeNode node, GraphSelection graphselection) {
        int num = node.getChildCount();
        if (num > 0) {
            Object obj1 = node.getUserObject();
            if (obj1 instanceof ParentNodeInfo) {
                ParentNodeInfo tmpnode = (ParentNodeInfo)obj1;
                List nodeobj = tmpnode.getNode_object();
                this.askparentPanel = nodeobj.getprintform();
                graphselection.addPrintCheckBox(this.askparentPanel);
            }
            for (int i = 0; i < num; ++i) {
                SortedTreeNode l = (SortedTreeNode)node.getChildAt(i);
                this.ask_treenode(l, graphselection);
            }
            this.askparentPanel = null;
        } else {
            Object obj1 = node.getUserObject();
            if (obj1 instanceof TreeNodeInfo) {
                TreeNodeInfo tmpnode = (TreeNodeInfo)obj1;
                Graph nodeobj = tmpnode.getNode_object();
                JCheckBox tmp = nodeobj.getprintform();
                if (this.askparentPanel == null) {
                    graphselection.addPrintCheckBox(tmp);
                } else {
                    this.askparentPanel.add(tmp);
                }
            }
        }
    }

    public void add2tree(SortedTreeNode parent, SortedTreeNode newNode) {
        DefaultTreeModel model = (DefaultTreeModel)this.jTree1.getModel();
        model.insertNodeInto(newNode, parent, parent.getChildCount());
    }

    public void treehome() {
        this.jTree1.setSelectionRow(0);
        this.jTree1.expandRow(0);
        this.jTree1.repaint();
    }

    public void notifyrun(boolean t) {
        this.exportMenu.setEnabled(!t);
        this.dataMenu.setEnabled(!t);
        if (t) {
            this.jButton1.setText("Stop");
            this.jButton1.setEnabled(true);
        } else {
            this.jButton1.setText("");
            this.jButton1.setEnabled(false);
        }
    }

    public void setHasData(boolean actif) {
        this.has_fresh_data = actif;
        this.exportMenu.setEnabled(actif);
        if (actif) {
            this.LoadFile.setText("Append from a file...");
            this.LoadCommand.setText("Append from a local Command...");
            this.LoadSSH.setText("Append from a SSH Command...");
        } else {
            this.LoadFile.setText("Load from a file...");
            this.LoadCommand.setText("Load from a local Command...");
            this.LoadSSH.setText("Load from a SSH Command...");
        }
    }

    private void save_data() {
        if (this.has_fresh_data) {
            log.info("need backup");
        }
    }
}

