/*
 * Decompiled with CFR 0.152.
 */
package net.atomique.ksar.ui;

import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import net.atomique.ksar.kSar;
import net.atomique.ksar.ui.AboutBox;
import net.atomique.ksar.ui.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Desktop
extends JFrame {
    private static final Logger log = LoggerFactory.getLogger(Desktop.class);
    private JMenuItem AboutMenu;
    private JDesktopPane DesktopPane;
    private JMenu FileMenu;
    private JMenu HelpMenu;
    private JMenuItem IconifyMenu;
    private JMenuItem MaximizeMenu;
    private JMenuBar MenuBar;
    private JMenuItem NewMenu;
    private JMenu OptionsMenu;
    private JMenuItem QuitMenu;
    private JMenuItem SysprefMenu;
    private JMenuItem TileMenu;
    private JMenu WindowMenu;

    public Desktop() {
        int wmargins = 90;
        int hmargins = 60;
        Rectangle desktopBounds = new Rectangle();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        for (int j = 0; j < gs.length; ++j) {
            GraphicsDevice gd = gs[j];
            GraphicsConfiguration gc = gd.getDefaultConfiguration();
            Rectangle screenBounds = gc.getBounds();
            log.debug("screen [{}] boundaries: {}", (Object)j, (Object)screenBounds.toString());
            if (j != 0) continue;
            desktopBounds = screenBounds;
            desktopBounds.x += wmargins;
            desktopBounds.y += hmargins;
            desktopBounds.width -= wmargins * 2;
            desktopBounds.height -= hmargins * 2;
        }
        this.initComponents();
        this.setBounds(desktopBounds);
        log.debug("desktop window boundaries: {}", (Object)this.getBounds().toString());
        this.DesktopPane.setDragMode(1);
        this.setVisible(true);
    }

    private static JInternalFrame[] filterFrame(JInternalFrame[] frames) {
        int n = 0;
        for (int i = 0; i < frames.length; ++i) {
            if (!frames[i].isVisible() || frames[i].isIcon()) continue;
            ++n;
        }
        JInternalFrame[] newfs = new JInternalFrame[n];
        int j = 0;
        for (int i = 0; i < frames.length; ++i) {
            if (!frames[i].isVisible() || frames[i].isIcon()) continue;
            newfs[j++] = frames[i];
        }
        return newfs;
    }

    public static void iconify(JDesktopPane desktopPane) {
        JInternalFrame[] frames = Desktop.filterFrame(desktopPane.getAllFrames());
        if (frames.length == 0) {
            return;
        }
        for (int i = 0; i < frames.length; ++i) {
            if (!frames[i].isVisible() || frames[i].isIcon()) continue;
            try {
                frames[i].setIcon(true);
                continue;
            }
            catch (PropertyVetoException ex) {
                log.error("PropertyVetoException", ex);
            }
        }
    }

    public void maxall() {
        Desktop.maximize(this.DesktopPane);
    }

    private static void maximize(JDesktopPane desktopPane) {
        JInternalFrame[] frames = Desktop.filterFrame(desktopPane.getAllFrames());
        if (frames.length == 0) {
            return;
        }
        for (int i = 0; i < frames.length; ++i) {
            if (!frames[i].isVisible() || frames[i].isIcon()) continue;
            try {
                frames[i].setMaximum(true);
                continue;
            }
            catch (PropertyVetoException ex) {
                log.error("PropertyVetoException", ex);
            }
        }
    }

    public static void tile(JDesktopPane desktopPane) {
        JInternalFrame[] frames = Desktop.filterFrame(desktopPane.getAllFrames());
        if (frames.length == 0) {
            return;
        }
        Desktop.tile(frames, desktopPane.getBounds());
    }

    private static void tile(JInternalFrame[] frames, Rectangle dBounds) {
        int width;
        int height;
        int rows;
        int cols = (int)Math.sqrt(frames.length);
        int lastRow = frames.length - cols * ((rows = (int)Math.ceil((double)frames.length / (double)cols)) - 1);
        if (lastRow == 0) {
            height = dBounds.height / --rows;
        } else {
            height = dBounds.height / rows;
            if (lastRow < cols) {
                --rows;
                width = dBounds.width / lastRow;
                for (int i = 0; i < lastRow; ++i) {
                    frames[cols * rows + i].setBounds(i * width, rows * height, width, height);
                }
            }
        }
        width = dBounds.width / cols;
        for (int j = 0; j < rows; ++j) {
            for (int i = 0; i < cols; ++i) {
                frames[i + j * cols].setBounds(i * width, j * height, width, height);
            }
        }
    }

    private void initComponents() {
        this.DesktopPane = new JDesktopPane();
        this.MenuBar = new JMenuBar();
        this.FileMenu = new JMenu();
        this.NewMenu = new JMenuItem();
        this.QuitMenu = new JMenuItem();
        this.OptionsMenu = new JMenu();
        this.SysprefMenu = new JMenuItem();
        this.WindowMenu = new JMenu();
        this.TileMenu = new JMenuItem();
        this.IconifyMenu = new JMenuItem();
        this.MaximizeMenu = new JMenuItem();
        this.HelpMenu = new JMenu();
        this.AboutMenu = new JMenuItem();
        this.setDefaultCloseOperation(0);
        this.setTitle("kSar : a sar grapher");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                Desktop.this.formWindowClosing(evt);
            }
        });
        this.getContentPane().add((Component)this.DesktopPane, "Center");
        this.FileMenu.setText("File");
        this.NewMenu.setText("New window");
        this.NewMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Desktop.this.NewMenuActionPerformed(evt);
            }
        });
        this.FileMenu.add(this.NewMenu);
        this.QuitMenu.setText("Quit");
        this.QuitMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Desktop.this.QuitMenuActionPerformed(evt);
            }
        });
        this.FileMenu.add(this.QuitMenu);
        this.MenuBar.add(this.FileMenu);
        this.OptionsMenu.setText("Options");
        this.SysprefMenu.setText("System Preferences");
        this.SysprefMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Desktop.this.SysprefMenuActionPerformed(evt);
            }
        });
        this.OptionsMenu.add(this.SysprefMenu);
        this.MenuBar.add(this.OptionsMenu);
        this.WindowMenu.setText("Window");
        this.TileMenu.setText("Tile");
        this.TileMenu.setActionCommand("TileMenu");
        this.TileMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Desktop.this.TileMenuActionPerformed(evt);
            }
        });
        this.WindowMenu.add(this.TileMenu);
        this.IconifyMenu.setText("Iconify");
        this.IconifyMenu.setActionCommand("IconifyMenu");
        this.IconifyMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Desktop.this.IconifyMenuActionPerformed(evt);
            }
        });
        this.WindowMenu.add(this.IconifyMenu);
        this.MaximizeMenu.setText("Maximize");
        this.MaximizeMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Desktop.this.MaximizeMenuActionPerformed(evt);
            }
        });
        this.WindowMenu.add(this.MaximizeMenu);
        this.MenuBar.add(this.WindowMenu);
        this.HelpMenu.setText("?");
        this.AboutMenu.setText("About");
        this.AboutMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Desktop.this.AboutMenuActionPerformed(evt);
            }
        });
        this.HelpMenu.add(this.AboutMenu);
        this.MenuBar.add(this.HelpMenu);
        this.setJMenuBar(this.MenuBar);
        this.pack();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.tryToQuit();
    }

    private void QuitMenuActionPerformed(ActionEvent evt) {
        this.tryToQuit();
    }

    private void AboutMenuActionPerformed(ActionEvent evt) {
        AboutBox myAboutBox = new AboutBox(this);
    }

    private void SysprefMenuActionPerformed(ActionEvent evt) {
        Preferences myPreferences = new Preferences(this);
    }

    private void NewMenuActionPerformed(ActionEvent evt) {
        this.add_window();
    }

    private void TileMenuActionPerformed(ActionEvent evt) {
        Desktop.tile(this.DesktopPane);
    }

    private void IconifyMenuActionPerformed(ActionEvent evt) {
        Desktop.iconify(this.DesktopPane);
    }

    private void MaximizeMenuActionPerformed(ActionEvent evt) {
        Desktop.maximize(this.DesktopPane);
    }

    public void add_window() {
        kSar mysar = new kSar(this.DesktopPane);
    }

    public JDesktopPane getDesktopPane() {
        return this.DesktopPane;
    }

    private void tryToQuit() {
        int i = JOptionPane.showConfirmDialog(this, "Are you sure you want to exit kSar ?", "Confirm", 0);
        if (i == 0) {
            System.exit(0);
        }
    }
}

