/*
 * Decompiled with CFR 0.152.
 */
package net.atomique.ksar.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.atomique.ksar.Config;
import net.atomique.ksar.GlobalOptions;
import net.atomique.ksar.graph.Graph;
import org.jfree.chart.ChartPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphView
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(GraphView.class);
    private JPanel buttonPanel;
    private JButton csvButton;
    private JButton ctrlcButton;
    private JPanel graphPanel;
    private JButton jpgBuitton;
    private JButton pngButton;
    private JButton printButton;
    private Graph thegraph = null;
    private ChartPanel mychartpanel = null;

    public GraphView() {
        this.initComponents();
    }

    public void setGraph(Graph graph) {
        this.thegraph = graph;
        if (this.mychartpanel != null) {
            this.graphPanel.remove(this.mychartpanel);
        }
        this.mychartpanel = graph.get_ChartPanel();
        this.graphPanel.add(this.mychartpanel);
        this.validate();
    }

    private void initComponents() {
        this.graphPanel = new JPanel();
        this.buttonPanel = new JPanel();
        this.csvButton = new JButton();
        this.jpgBuitton = new JButton();
        this.pngButton = new JButton();
        this.ctrlcButton = new JButton();
        this.printButton = new JButton();
        this.setLayout(new BorderLayout());
        this.graphPanel.setLayout(new BorderLayout());
        this.add((Component)this.graphPanel, "Center");
        this.csvButton.setText("Export CSV");
        this.csvButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphView.this.csvButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.csvButton);
        this.jpgBuitton.setText("Export JPG");
        this.jpgBuitton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphView.this.jpgBuittonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.jpgBuitton);
        this.pngButton.setText("Export PNG");
        this.pngButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphView.this.pngButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.pngButton);
        this.ctrlcButton.setText("Copy");
        this.ctrlcButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphView.this.ctrlcButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.ctrlcButton);
        this.printButton.setText("Print");
        this.printButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphView.this.printButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.printButton);
        this.add((Component)this.buttonPanel, "South");
    }

    private void csvButtonActionPerformed(ActionEvent evt) {
        String filename = null;
        String buffer = null;
        filename = this.askSaveFilename("Export CSV", Config.getLastExportDirectory());
        if (filename == null) {
            return;
        }
        Config.setLastExportDirectory(filename);
        if (!Config.getLastExportDirectory().isDirectory()) {
            Config.setLastExportDirectory(Config.getLastExportDirectory().getParentFile());
            Config.save();
        }
        buffer = this.thegraph.make_csv();
        if (GlobalOptions.isDodebug()) {
            log.debug(buffer);
        }
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(filename));
        }
        catch (IOException e) {
            out = null;
        }
        if (out == null) {
            return;
        }
        try {
            out.write(buffer);
            out.flush();
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void jpgBuittonActionPerformed(ActionEvent evt) {
        String filename = this.askSaveFilename("Export JPG", Config.getLastExportDirectory());
        if (filename == null) {
            return;
        }
        this.thegraph.saveJPG(filename, Config.getImageWidth(), Config.getImageHeight());
    }

    private void ctrlcButtonActionPerformed(ActionEvent evt) {
        this.mychartpanel.doCopy();
    }

    private void printButtonActionPerformed(ActionEvent evt) {
        this.mychartpanel.createChartPrintJob();
    }

    private void pngButtonActionPerformed(ActionEvent evt) {
        String filename = this.askSaveFilename("Export PNG", Config.getLastExportDirectory());
        if (filename == null) {
            return;
        }
        this.thegraph.savePNG(filename, Config.getImageWidth(), Config.getImageHeight());
    }

    private String askSaveFilename(String title, File chdirto) {
        int returnVal;
        String filename = null;
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(title);
        if (chdirto != null) {
            chooser.setCurrentDirectory(chdirto);
        }
        if ((returnVal = chooser.showSaveDialog(GlobalOptions.getUI())) == 0) {
            filename = chooser.getSelectedFile().getAbsolutePath();
        }
        if (filename == null) {
            return null;
        }
        if (new File(filename).exists()) {
            Object[] choix = new String[]{"Yes", "No"};
            int resultat = JOptionPane.showOptionDialog(null, "Overwrite " + filename + " ?", "File Exist", 1, 3, null, choix, choix[1]);
            if (resultat != 0) {
                return null;
            }
        }
        return filename;
    }
}

